/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.wildfly.agent.itest.util;

import java.io.IOException;
import org.hawkular.agent.monitor.protocol.dmr.DMREndpointService;
import org.hawkular.wildfly.agent.itest.util.AbstractITest;
import org.jboss.as.controller.client.ModelControllerClient;

public class WildFlyClientConfig {
    private final String wfHost = System.getProperty("plain-wildfly.bind.address");
    private final int wfManagementPort = Integer.parseInt(System.getProperty("plain-wildfly.management.http.port"));
    private final String wfFeedId;

    public WildFlyClientConfig() {
        try (ModelControllerClient mcc = AbstractITest.newModelControllerClient(this.wfHost, this.wfManagementPort);){
            this.wfFeedId = DMREndpointService.lookupServerIdentifier((ModelControllerClient)mcc);
            System.out.println(String.format("Plain WF: %s:%d->%s", this.wfHost, this.wfManagementPort, this.wfFeedId));
        }
        catch (IOException e) {
            throw new RuntimeException("Could not get wfFeedId", e);
        }
    }

    public String getHost() {
        return this.wfHost;
    }

    public int getManagementPort() {
        return this.wfManagementPort;
    }

    public String getFeedId() {
        return this.wfFeedId;
    }
}

