/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.example;

import java.util.Collections;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.Singleton;
import org.hawkular.agent.example.MyAppInventory;
import org.hawkular.agent.example.MyAppSamplingService;
import org.hawkular.agent.monitor.api.Avail;
import org.hawkular.agent.monitor.api.AvailDataPayloadBuilder;
import org.hawkular.agent.monitor.api.AvailStorage;
import org.hawkular.agent.monitor.api.HawkularAgentContext;
import org.hawkular.agent.monitor.api.InventoryEvent;
import org.hawkular.agent.monitor.api.MetricDataPayloadBuilder;
import org.hawkular.agent.monitor.api.MetricStorage;
import org.hawkular.agent.monitor.api.SamplingService;
import org.hawkular.agent.monitor.inventory.ResourceManager;
import org.hawkular.metrics.client.common.MetricType;
import org.jboss.logging.Logger;

@Singleton
public class HawkularWildFlyAgentProvider {
    private static final Logger log = Logger.getLogger(HawkularWildFlyAgentProvider.class);
    private static final String AGENT_JNDI = "java:global/hawkular/agent/api";
    static final String TENANT_ID = null;
    @Resource(name="java:global/hawkular/agent/api")
    private HawkularAgentContext hawkularAgent;
    private MyAppSamplingService myAppSamplingService;
    private MyAppInventory myAppInventory;

    @PostConstruct
    public void postConstruct() {
        if (this.hawkularAgent == null) {
            log.debugf("The Hawkular WildFly Agent is either disabled or not deployed. It is unavailable for use.", new Object[0]);
        }
        this.myAppSamplingService = new MyAppSamplingService();
        this.myAppInventory = new MyAppInventory();
    }

    public void sendMetric(String metricKey, Double metricValue, MetricType metricType) {
        HawkularAgentContext hawkularWildFlyAgent = this.getHawkularWildFlyAgent();
        MetricStorage metricStorage = hawkularWildFlyAgent.getMetricStorage();
        MetricDataPayloadBuilder payloadBuilder = metricStorage.createMetricDataPayloadBuilder();
        payloadBuilder.addDataPoint(metricKey, System.currentTimeMillis(), metricValue.doubleValue(), metricType);
        payloadBuilder.setTenantId(TENANT_ID);
        metricStorage.store(payloadBuilder, 0L);
    }

    public void sendStringMetric(String metricKey, String metricValue) {
        HawkularAgentContext hawkularWildFlyAgent = this.getHawkularWildFlyAgent();
        MetricStorage metricStorage = hawkularWildFlyAgent.getMetricStorage();
        MetricDataPayloadBuilder payloadBuilder = metricStorage.createMetricDataPayloadBuilder();
        payloadBuilder.addDataPoint(metricKey, System.currentTimeMillis(), metricValue);
        payloadBuilder.setTenantId(TENANT_ID);
        metricStorage.store(payloadBuilder, 0L);
    }

    public void sendAvail(String availKey, Avail availValue) {
        HawkularAgentContext hawkularWildFlyAgent = this.getHawkularWildFlyAgent();
        AvailStorage availStorage = hawkularWildFlyAgent.getAvailStorage();
        AvailDataPayloadBuilder payloadBuilder = availStorage.createAvailDataPayloadBuilder();
        payloadBuilder.addDataPoint(availKey, System.currentTimeMillis(), availValue);
        payloadBuilder.setTenantId(TENANT_ID);
        availStorage.store(payloadBuilder, 0L);
    }

    public void addResourceToInventory(String resourceId) {
        org.hawkular.agent.monitor.inventory.Resource newResource = this.myAppInventory.getResource(resourceId);
        if (newResource != null) {
            throw new RuntimeException("Cannot add an already known resource: " + newResource);
        }
        newResource = this.myAppInventory.instantiateResource(resourceId);
        this.myAppInventory.addResource(newResource);
        InventoryEvent iEvent = InventoryEvent.addedOrModified((SamplingService)this.myAppSamplingService, (ResourceManager)this.myAppInventory.getResourceManager(), Collections.singletonList(newResource));
        this.getHawkularWildFlyAgent().getInventoryStorage().receivedEvent(iEvent);
    }

    public void removeResourceFromInventory(String doomedResourceId) {
        org.hawkular.agent.monitor.inventory.Resource doomedResource = this.myAppInventory.getResource(doomedResourceId);
        if (doomedResource == null) {
            throw new RuntimeException("Cannot remove unknown resource: " + doomedResource);
        }
        this.myAppInventory.removeResource(doomedResource);
        InventoryEvent iEvent = InventoryEvent.removed((SamplingService)this.myAppSamplingService, (ResourceManager)this.myAppInventory.getResourceManager(), Collections.singletonList(doomedResource));
        this.getHawkularWildFlyAgent().getInventoryStorage().receivedEvent(iEvent);
    }

    private HawkularAgentContext getHawkularWildFlyAgent() throws UnsupportedOperationException {
        if (this.hawkularAgent == null) {
            throw new UnsupportedOperationException("The Hawkular WildFly Agent is either disabled or not deployed and thus is not available for use.");
        }
        return this.hawkularAgent;
    }
}

