/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.example;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.Singleton;
import org.hawkular.agent.example.MyAppInventory;
import org.hawkular.agent.example.MyAppSamplingService;
import org.hawkular.agent.monitor.api.Avail;
import org.hawkular.agent.monitor.api.AvailDataPayloadBuilder;
import org.hawkular.agent.monitor.api.AvailStorage;
import org.hawkular.agent.monitor.api.DiscoveryEvent;
import org.hawkular.agent.monitor.api.HawkularWildFlyAgentContext;
import org.hawkular.agent.monitor.api.InventoryEvent;
import org.hawkular.agent.monitor.api.MetricDataPayloadBuilder;
import org.hawkular.agent.monitor.api.MetricStorage;
import org.hawkular.agent.monitor.api.SamplingService;
import org.hawkular.metrics.client.common.MetricType;
import org.jboss.logging.Logger;

@Singleton
public class HawkularWildFlyAgentProvider {
    private static final Logger log = Logger.getLogger(HawkularWildFlyAgentProvider.class);
    private static final String AGENT_JNDI = "java:global/hawkular/agent/api";
    static final String TENANT_ID = "my-app-tenant";
    @Resource(name="java:global/hawkular/agent/api")
    private HawkularWildFlyAgentContext hawkularAgent;
    private MyAppSamplingService myAppSamplingService;
    private MyAppInventory myAppInventory;

    @PostConstruct
    public void postConstruct() {
        if (this.hawkularAgent == null) {
            log.debugf("The Hawkular WildFly Agent is either disabled or not deployed. It is unavailable for use.", new Object[0]);
        }
        this.myAppSamplingService = new MyAppSamplingService();
        this.myAppInventory = new MyAppInventory();
    }

    public void sendMetric(String metricKey, Double metricValue, MetricType metricType) {
        HawkularWildFlyAgentContext hawkularWildFlyAgent = this.getHawkularWildFlyAgent();
        MetricStorage metricStorage = hawkularWildFlyAgent.getMetricStorage();
        MetricDataPayloadBuilder payloadBuilder = metricStorage.createMetricDataPayloadBuilder();
        payloadBuilder.addDataPoint(metricKey, System.currentTimeMillis(), metricValue.doubleValue(), metricType);
        payloadBuilder.setTenantId(TENANT_ID);
        metricStorage.store(payloadBuilder, 0L);
    }

    public void sendAvail(String availKey, Avail availValue) {
        HawkularWildFlyAgentContext hawkularWildFlyAgent = this.getHawkularWildFlyAgent();
        AvailStorage availStorage = hawkularWildFlyAgent.getAvailStorage();
        AvailDataPayloadBuilder payloadBuilder = availStorage.createAvailDataPayloadBuilder();
        payloadBuilder.addDataPoint(availKey, System.currentTimeMillis(), availValue);
        payloadBuilder.setTenantId(TENANT_ID);
        availStorage.store(payloadBuilder, 0L);
    }

    public void addResourceToInventory(String resourceId) {
        org.hawkular.agent.monitor.inventory.Resource newResource = this.myAppInventory.getResource(resourceId);
        if (newResource != null) {
            throw new RuntimeException("Cannot add an already known resource: " + newResource);
        }
        newResource = this.myAppInventory.instantiateResource(resourceId);
        this.myAppInventory.addResource(newResource);
        List<org.hawkular.agent.monitor.inventory.Resource> resources = Arrays.asList(newResource);
        InventoryEvent iEvent = new InventoryEvent((SamplingService)this.myAppSamplingService, resources);
        this.getHawkularWildFlyAgent().getInventoryStorage().resourcesAdded(iEvent);
        this.syncAllResourceTypes();
        DiscoveryEvent dEvent = new DiscoveryEvent((SamplingService)this.myAppSamplingService, this.myAppInventory.getResourceManager());
        this.getHawkularWildFlyAgent().getInventoryStorage().discoveryCompleted(dEvent);
    }

    public void removeResourceFromInventory(String doomedResourceId) {
        org.hawkular.agent.monitor.inventory.Resource doomedResource = this.myAppInventory.getResource(doomedResourceId);
        if (doomedResource == null) {
            throw new RuntimeException("Cannot remove unknown resource: " + doomedResource);
        }
        this.myAppInventory.removeResource(doomedResource);
        List<org.hawkular.agent.monitor.inventory.Resource> resources = Arrays.asList(doomedResource);
        InventoryEvent iEvent = new InventoryEvent((SamplingService)this.myAppSamplingService, resources);
        this.getHawkularWildFlyAgent().getInventoryStorage().resourcesRemoved(iEvent);
        this.syncAllResourceTypes();
        DiscoveryEvent dEvent = new DiscoveryEvent((SamplingService)this.myAppSamplingService, this.myAppInventory.getResourceManager());
        this.getHawkularWildFlyAgent().getInventoryStorage().discoveryCompleted(dEvent);
    }

    private void syncAllResourceTypes() {
        HashMap<String, List> allTypes = new HashMap<String, List>();
        allTypes.put(TENANT_ID, this.myAppInventory.getResourceTypeManager().getResourceTypesBreadthFirst());
        this.getHawkularWildFlyAgent().getInventoryStorage().allResourceTypes(allTypes);
    }

    private HawkularWildFlyAgentContext getHawkularWildFlyAgent() throws UnsupportedOperationException {
        if (this.hawkularAgent == null) {
            throw new UnsupportedOperationException("The Hawkular WildFly Agent is either disabled or not deployed and thus is not available for use.");
        }
        return this.hawkularAgent;
    }
}

