/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.bus.common;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import java.io.IOException;
import org.hawkular.bus.common.AbstractMessage;

public class ObjectMessage
extends AbstractMessage {
    @JsonInclude
    private String message;
    @JsonIgnore
    private Class<?> objectClass;
    @JsonIgnore
    private final ObjectMapper mapper = new ObjectMapper();

    public ObjectMessage() {
        this.mapper.setVisibilityChecker((VisibilityChecker<?>)this.mapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE));
    }

    public ObjectMessage(Object object) {
        this.mapper.setVisibilityChecker((VisibilityChecker<?>)this.mapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE));
        if (object == null) {
            throw new IllegalArgumentException("object is null");
        }
        this.setObjectClass(object.getClass());
        try {
            String msg = this.mapper.writeValueAsString(object);
            this.setMessage(msg);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Object cannot be parsed as JSON.", e);
        }
    }

    public ObjectMessage(Class<?> clazz) {
        this.mapper.setVisibilityChecker((VisibilityChecker<?>)this.mapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE));
        if (clazz == null) {
            throw new IllegalArgumentException("clazz is null");
        }
        this.setObjectClass(clazz);
    }

    public String getMessage() {
        return this.message;
    }

    protected void setMessage(String msg) {
        this.message = msg;
    }

    public Class<?> getObjectClass() {
        return this.objectClass;
    }

    public void setObjectClass(Class<?> objectClass) {
        this.objectClass = objectClass;
    }

    public Object getObject() {
        Class<?> clazz = this.getObjectClass();
        if (clazz == null) {
            throw new IllegalStateException("Do not know what the class is that represents the JSON data");
        }
        try {
            return this.mapper.readValue(this.getMessage(), clazz);
        }
        catch (IOException e) {
            throw new IllegalStateException("JSON message cannot be converted to object.", e);
        }
    }
}

