/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.backend.control;

import java.util.HashMap;
import javax.annotation.security.PermitAll;
import javax.ejb.Singleton;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.mail.internet.InternetAddress;
import org.hawkular.accounts.api.InvitationService;
import org.hawkular.accounts.api.model.Invitation;
import org.hawkular.accounts.backend.control.MsgLogger;
import org.hawkular.accounts.backend.entity.InvitationCreatedEvent;
import org.hawkular.commons.email.EmailDispatcher;

@PermitAll
@Singleton
public class InvitationDispatcher {
    public static final String HAWKULAR_BASE_URL = "HAWKULAR_BASE_URL";
    public static final String DEFAULT_HAWKULAR_BASE_URL = System.getenv("HAWKULAR_BASE_URL") == null ? "http://localhost:8080/" : System.getenv("HAWKULAR_BASE_URL");
    MsgLogger logger = MsgLogger.LOGGER;
    @Inject
    EmailDispatcher emailDispatcher;
    @Inject
    InvitationService invitationService;

    public void dispatchInvitation(@Observes InvitationCreatedEvent event) {
        boolean sent;
        Invitation invitation = event.getInvitation();
        if (null == invitation) {
            throw new IllegalArgumentException("Invitation event doesn't contain an invitation.");
        }
        invitation = this.invitationService.get(invitation.getId());
        HashMap<String, String> properties = new HashMap<String, String>(3);
        properties.put("acceptUrl", DEFAULT_HAWKULAR_BASE_URL + "hawkular-ui/invitation/accept/" + invitation.getToken());
        properties.put("invitedBy", invitation.getInvitedBy().getName());
        properties.put("orgName", invitation.getOrganization().getName());
        try {
            sent = this.emailDispatcher.dispatch(new InternetAddress(invitation.getEmail()), "[hawkular] - You have been invited to join an organization.", "invitation_plain.ftl", "invitation_html.ftl", properties);
        }
        catch (Exception e) {
            this.logger.invitationExceptionSendingMessage(invitation.getId(), e.getMessage());
            return;
        }
        if (sent) {
            this.invitationService.markAsDispatched(invitation);
            this.logger.invitationSubmitted(invitation.getId(), invitation.getToken());
        }
    }
}

