/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.backend.control;

import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;

@MessageLogger(projectCode="HAWKACC")
@ValidIdRange(min=110000, max=119999)
public interface MsgLogger {
    public static final MsgLogger LOGGER = (MsgLogger)Logger.getMessageLogger(MsgLogger.class, (String)MsgLogger.class.getPackage().getName());

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=110000, value="Started setting up Hawkular Accounts.")
    public void startedSetupAccounts();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=110001, value="Finished setting up Hawkular Accounts.")
    public void finishedSetupAccounts();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=110004, value="Invitation [%s] submitted. Token: [%s].")
    public void invitationSubmitted(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=110005, value="Invitation [%s] is being reused by a different user [%s]. It was accepted by: [%s].")
    public void invitationReused(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=110006, value="An exception has occurred while sending the message for invitation [%s]. Exception: [%s]")
    public void invitationExceptionSendingMessage(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=110007, value="Join request made by a company. Not sending notifications.")
    public void joinRequestToOrganization();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=110008, value="Join request made by an user with unknown email address. Not sending notifications.")
    public void joinRequestUserEmailIsEmpty();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=110009, value="Failed to dispatch notification for accepted join request [%s]. Exception: ")
    public void joinRequestFailToSendAcceptedNotification(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=110010, value="Failed to dispatch notification for rejected join request [%s]. Exception: ")
    public void joinRequestFailToSendRejectedNotification(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=110011, value="Email address for organization's owner is not available. Not sending notifications.")
    public void joinRequestOwnersEmailIsEmpty();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=110012, value="Failed to dispatch notification for join request [%s]. Exception: ")
    public void joinRequestFailToSendNotification(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110013, value="No organization provided.")
    public void missingOrganization();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110014, value="Organization [%s] not found.")
    public void organizationNotFound(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110015, value="Operation [%s] on [%s] cannot be performed by [%s].")
    public void notAllowedToPerformOperationOnResource(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110016, value="Returning list of pending invitations for organization [%s].")
    public void listPendingInvitations(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110017, value="Missing emails to send the invitation to.")
    public void missingEmails();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110018, value="Invitations queued for dispatching.")
    public void invitationsSentToDispatch();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110019, value="Invitation [%s] sent to [%s] to join the organization [%s].")
    public void invitationSentToDispatch(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110020, value="Missing token, cannot determine which invitation is being accepted.")
    public void missingToken();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110021, value="Could not find the invitation for the token [%s].")
    public void invitationNotFound(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110022, value="The invitation [%s] is being accepted by the same user who created it: [%s].")
    public void invitationAcceptedBySameUser(String var1, String var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110023, value="The invitation [%s] has been accepted by [%s].")
    public void invitationAccepted(String var1, String var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110024, value="The persona [%s] is allowed to access [%d] organizations.")
    public void numberOfOrganizationsForPersona(String var1, int var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110025, value="The persona [%s] is allowed to access [%d] organizations.")
    public void filteredOrganizationsWithReadPermission(String var1, int var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110026, value="The persona [%s] can join [%d] organizations.")
    public void filteredOrganizationsToJoin(String var1, int var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110027, value="The organization [%s] is trying to create an organization, which is not supported.")
    public void organizationTryingToCreateOrganization(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110028, value="A name is required in order to create an organization.")
    public void missingOrganizationName();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110029, value="An organization with the same name already exists.")
    public void duplicateOrganizationName();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110030, value="Missing visibility for new organization.")
    public void missingVisibility();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110031, value="Created organization [%s] with name [%s] and visibility [%s].")
    public void createdOrganization(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110032, value="Cannot remove organization [%s] as it has sub organizations.")
    public void organizationHasSuborganizations(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110033, value="Cannot remove organization [%s] as it has resources.")
    public void organizationHasResources(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110034, value="Organization [%s] has been removed.")
    public void organizationRemoved(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110035, value="Organization [%s] has been found.")
    public void organizationFound(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110036, value="The given user ID is invalid (null).")
    public void missingUser();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110037, value="The user with the ID [%s] was not found.")
    public void userNotFound(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110038, value="Organization [%s] has been transferred to [%s].")
    public void organizationTransferred(String var1, String var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110039, value="Received a request to add persona [%s] to organization [%s], but user already belongs to it.")
    public void alreadyMemberOfOrganization(String var1, String var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110040, value="The user [%s] has tried to send a join request to organization [%s], but organization is private and cannot accept invitations.")
    public void privateOrganizationCannotAcceptJoinRequests(String var1, String var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110041, value="Join request from persona [%s] to organization [%s] has been created.")
    public void joinRequestCreated(String var1, String var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110042, value="No decision provided.")
    public void missingDecision();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110043, value="Join request [%s] not found.")
    public void joinRequestNotFound(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110044, value="Persona [%s] tried to accept a join request for [%s], but the join request was made to join [%s]. Rejecting request.")
    public void joinRequestBelongsToAnotherCompany(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110045, value="Persona [%s] tried to accept the join request [%s], but a decision about the join request has already been made.")
    public void joinRequestAlreadyDecidedUpon(String var1, String var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110046, value="The decision [%s] is invalid.")
    public void unknownDecision(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110047, value="The decision for the join request [%s] has been made: [%s].")
    public void decisionMade(String var1, String var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110048, value="Listing only pending join requests.")
    public void listOnlyPendingJoinRequests();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110049, value="Listing all join requests.")
    public void listAllJoinRequests();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110050, value="Listing all join requests for persona [%s] resulted in [%d] records.")
    public void listAllJoinRequestsForPersona(String var1, int var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110051, value="Listing pending join requests for persona [%s] resulted in [%d] records.")
    public void listPendingJoinRequestsForPersona(String var1, int var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110052, value="Missing membership ID (null).")
    public void missingMembershipId();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110053, value="The membership [%s] could not be found.")
    public void membershipNotFound(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110054, value="The membership [%s] found.")
    public void membershipFound(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110055, value="Organization [%s] has [%d] memberships.")
    public void numberOfMembershipsForOrganization(String var1, int var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110056, value="Missing role name (null).")
    public void missingRole();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110057, value="Role [%s] not found.")
    public void roleNotFound(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110058, value="The membership [%s] has been updated to have role [%s].")
    public void roleForMembershipChanged(String var1, String var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110059, value="Missing resource ID (null).")
    public void missingResource();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110060, value="Missing operation (null).")
    public void missingOperation();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110061, value="Resource [%s] not found.")
    public void resourceNotFound(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110062, value="Operation [%s] not found.")
    public void operationNotFound(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110063, value="Permission for [%s] on [%s] for persona [%s] resulted in [%b].")
    public void permissionResponsePrepared(String var1, String var2, String var3, boolean var4);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110064, value="User [%s] is allowed to use [%d] personas.")
    public void userWithPersonas(String var1, int var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110065, value="User [%s] is allowed to use the persona [%s].")
    public void userCanAccessPersona(String var1, String var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110066, value="User [%s] is not allowed to use the persona [%d], or persona doesn't exist.")
    public void userCannotAccessPersona(String var1, String var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110067, value="Persona for the current request: [%s].")
    public void personaForRequest(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110068, value="Persona [%s], on resource [%s], has [%d] roles.")
    public void numberOfRolesForPersonaOnResource(String var1, String var2, int var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=110069, value="Persona [%s] has [%d] settings.")
    public void settingsForPersona(String var1, int var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=110070, value="An invitation event was created without event.")
    public void invitationEventWithoutInvitation();
}

