/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.backend.boundary;

import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.hawkular.accounts.api.CurrentUser;
import org.hawkular.accounts.api.InvitationService;
import org.hawkular.accounts.api.NamedOperation;
import org.hawkular.accounts.api.OrganizationService;
import org.hawkular.accounts.api.PermissionChecker;
import org.hawkular.accounts.api.RoleService;
import org.hawkular.accounts.api.model.HawkularUser;
import org.hawkular.accounts.api.model.Invitation;
import org.hawkular.accounts.api.model.Operation;
import org.hawkular.accounts.api.model.Organization;
import org.hawkular.accounts.api.model.Role;
import org.hawkular.accounts.backend.control.MsgLogger;
import org.hawkular.accounts.backend.entity.InvitationCreatedEvent;
import org.hawkular.accounts.backend.entity.rest.ErrorResponse;
import org.hawkular.accounts.backend.entity.rest.InvitationAcceptRequest;
import org.hawkular.accounts.backend.entity.rest.InvitationRequest;

@Path(value="/invitations")
@PermitAll
@Stateless
public class InvitationEndpoint {
    private static final MsgLogger logger = MsgLogger.LOGGER;
    private static final String DEFAULT_ROLE = "Monitor";
    @Inject
    RoleService roleService;
    @Inject
    OrganizationService organizationService;
    @Inject
    InvitationService invitationService;
    @Inject
    @CurrentUser
    Instance<HawkularUser> userInstance;
    @Inject
    Event<InvitationCreatedEvent> event;
    @Inject
    PermissionChecker permissionChecker;
    @Inject
    @NamedOperation(value="organization-list-invitations")
    Operation operationListInvitations;
    @Inject
    @NamedOperation(value="organization-invite")
    Operation operationInvite;

    @GET
    public Response listPendingInvitations(@QueryParam(value="organizationId") String organizationId) {
        Organization organization = this.organizationService.get(organizationId);
        if (null == organization) {
            String message = "The organization could not be found.";
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)message).build();
        }
        if (!this.permissionChecker.isAllowedTo(this.operationListInvitations, organizationId)) {
            String message = "Insufficient permissions to list the pending invitations for this organization.";
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)message).build();
        }
        return Response.ok((Object)this.invitationService.getPendingInvitationsForOrganization(organization)).build();
    }

    @POST
    public Response inviteUserToOrganization(@NotNull InvitationRequest request) {
        String[] emails;
        HawkularUser user = (HawkularUser)this.userInstance.get();
        Organization organization = this.organizationService.get(request.getOrganizationId());
        if (null == organization) {
            String message = "The organization could not be found.";
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)message).build();
        }
        if (!this.permissionChecker.isAllowedTo(this.operationInvite, organization.getId())) {
            String message = "Insufficient permissions to list the pending invitations for this organization.";
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)message).build();
        }
        Role role = this.roleService.getByName(DEFAULT_ROLE);
        for (String email : emails = request.getEmails().split("[, ]")) {
            if (email.isEmpty()) continue;
            Invitation invitation = this.invitationService.create(email, user, organization, role);
            this.event.fire((Object)new InvitationCreatedEvent(invitation));
        }
        return Response.noContent().build();
    }

    @PUT
    public Response acceptInvitation(@NotNull InvitationAcceptRequest request) {
        HawkularUser user = (HawkularUser)this.userInstance.get();
        Invitation invitation = this.invitationService.getByToken(request.getToken());
        if (null == invitation) {
            String message = "The invitation has not been found.";
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorResponse(message)).build();
        }
        if (user.equals((Object)invitation.getInvitedBy())) {
            String message = "The invitation has been created by the same user who is accepting it.";
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorResponse(message)).build();
        }
        if (invitation.getAcceptedAt() != null) {
            String message = "This invitation has already been previously accepted.";
            if (!user.equals((Object)invitation.getAcceptedBy())) {
                message = "This invitation has already been previously accepted by a different user.";
                logger.invitationReused(invitation.getId(), user.getId(), invitation.getAcceptedBy().getId());
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorResponse(message)).build();
        }
        invitation = this.invitationService.accept(invitation, user);
        return Response.ok((Object)invitation).build();
    }
}

