/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.backend.boundary;

import java.util.Set;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.hawkular.accounts.api.PersonaService;
import org.hawkular.accounts.api.ResourceService;
import org.hawkular.accounts.api.model.Persona;
import org.hawkular.accounts.api.model.Resource;
import org.hawkular.accounts.backend.control.MsgLogger;

@Path(value="/roles")
@PermitAll
@Stateless
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class RoleEndpoint {
    MsgLogger logger = MsgLogger.LOGGER;
    @Inject
    Instance<Persona> personaInstance;
    @Inject
    PersonaService personaService;
    @Inject
    ResourceService resourceService;

    @GET
    public Response getRoleForResource(@QueryParam(value="resourceId") String resourceId) {
        if (null == resourceId) {
            this.logger.missingResource();
            String message = "The given resource ID is invalid (null).";
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)message).build();
        }
        Resource resource = this.resourceService.get(resourceId);
        if (null == resource) {
            this.logger.resourceNotFound(resourceId);
            String message = "Resource not found.";
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)message).build();
        }
        Set roles = this.personaService.getEffectiveRolesForResource((Persona)this.personaInstance.get(), resource);
        this.logger.numberOfRolesForPersonaOnResource(((Persona)this.personaInstance.get()).getId(), resourceId, roles.size());
        return Response.ok((Object)roles).build();
    }
}

