/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.backend.control;

import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;

@MessageLogger(projectCode="HAWKACC")
@ValidIdRange(min=110000, max=119999)
public interface MsgLogger {
    public static final MsgLogger LOGGER = (MsgLogger)Logger.getMessageLogger(MsgLogger.class, (String)MsgLogger.class.getPackage().getName());

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=110000, value="Started setting up Hawkular Accounts")
    public void infoStartedSetupAccounts();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=110001, value="Finished setting up Hawkular Accounts")
    public void infoFinishedSetupAccounts();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=110004, value="Invitation [%s] submitted. Token: [%s]")
    public void invitationSubmitted(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=110005, value="Invitation [%s] is being reused by a different user [%s]. It was accepted by: [%s]")
    public void invitationReused(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=110006, value="An exception has occurred while sending the message for invitation [%s]. Exception: [%s]")
    public void invitationExceptionSendingMessage(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=110007, value="Join request made by a company. Not sending notifications.")
    public void joinRequestToOrganization();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=110008, value="Join request made by an user with unknown email address. Not sending notifications.")
    public void joinRequestUserEmailIsEmpty();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=110009, value="Failed to dispatch notification for accepted join request [%s]. Exception: ")
    public void joinRequestFailToSendAcceptedNotification(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=110010, value="Failed to dispatch notification for rejected join request [%s]. Exception: ")
    public void joinRequestFailToSendRejectedNotification(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=110011, value="Email address for organization's owner is not available. Not sending notifications.")
    public void joinRequestOwnersEmailIsEmpty();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=110012, value="Failed to dispatch notification for join request [%s]. Exception: ")
    public void joinRequestFailToSendNotification(String var1, @Cause Throwable var2);
}

