/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.backend.boundary;

import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.hawkular.accounts.api.CurrentUser;
import org.hawkular.accounts.api.OrganizationService;
import org.hawkular.accounts.api.model.HawkularUser;
import org.hawkular.accounts.api.model.Organization;
import org.hawkular.accounts.api.model.Persona;

@Path(value="/personas")
@PermitAll
@Stateless
public class PersonaEndpoint {
    @Inject
    Instance<Persona> personaInstance;
    @Inject
    @CurrentUser
    Instance<HawkularUser> userInstance;
    @Inject
    OrganizationService organizationService;

    @GET
    @Path(value="/")
    public Response getPersonas() {
        HawkularUser user = (HawkularUser)this.userInstance.get();
        ArrayList<HawkularUser> personas = new ArrayList<HawkularUser>();
        personas.addAll(this.organizationService.getOrganizationsForPersona((Persona)user));
        personas.add(user);
        return Response.ok().entity(personas).build();
    }

    @GET
    @Path(value="/{id:[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}}")
    public Response getPersonas(@PathParam(value="id") String personaId) {
        HawkularUser user = (HawkularUser)this.userInstance.get();
        Optional<Organization> optionalPersona = this.organizationService.getOrganizationsForPersona((Persona)user).stream().filter(p -> p.getIdAsUUID().equals(UUID.fromString(personaId))).findFirst();
        if (optionalPersona.isPresent()) {
            return Response.ok().entity((Object)optionalPersona.get()).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="/current")
    public Response getCurrentPersona() {
        return Response.ok().entity(this.personaInstance.get()).build();
    }
}

