/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.backend.boundary;

import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.validation.constraints.NotNull;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.hawkular.accounts.api.CurrentUser;
import org.hawkular.accounts.api.NamedOperation;
import org.hawkular.accounts.api.OrganizationService;
import org.hawkular.accounts.api.PermissionChecker;
import org.hawkular.accounts.api.ResourceService;
import org.hawkular.accounts.api.internal.adapter.HawkularAccounts;
import org.hawkular.accounts.api.model.HawkularUser;
import org.hawkular.accounts.api.model.Operation;
import org.hawkular.accounts.api.model.Organization;
import org.hawkular.accounts.api.model.Organization_;
import org.hawkular.accounts.api.model.Persona;
import org.hawkular.accounts.backend.entity.rest.ErrorResponse;
import org.hawkular.accounts.backend.entity.rest.OrganizationRequest;

@Path(value="/organizations")
@PermitAll
@Stateless
public class OrganizationEndpoint {
    @Inject
    @HawkularAccounts
    EntityManager em;
    @Inject
    Persona persona;
    @Inject
    @CurrentUser
    HawkularUser user;
    @Inject
    PermissionChecker permissionChecker;
    @Inject
    @NamedOperation(value="organization-create")
    Operation operationCreate;
    @Inject
    @NamedOperation(value="organization-read")
    Operation operationRead;
    @Inject
    @NamedOperation(value="organization-update")
    Operation operationUpdate;
    @Inject
    @NamedOperation(value="organization-delete")
    Operation operationDelete;
    @Inject
    ResourceService resourceService;
    @Inject
    OrganizationService organizationService;

    @GET
    @Path(value="/")
    public Response getOrganizationsForPersona() {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Organization.class);
        Root root = query.from(Organization.class);
        query.select((Selection)root);
        query.where((Expression)builder.equal((Expression)root.get(Organization_.owner), (Object)this.persona));
        return Response.ok().entity((Object)this.em.createQuery(query).getResultList()).build();
    }

    @POST
    @Path(value="/")
    public Response createOrganization(@NotNull OrganizationRequest request) {
        if (!this.persona.equals((Object)this.user)) {
            String message = "Organizations cannot create sub-organizations.";
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)message).build();
        }
        Organization organization = this.organizationService.createOrganization(request.getName(), request.getDescription(), this.persona);
        this.resourceService.create(organization.getId(), this.persona);
        return Response.ok().entity((Object)organization).build();
    }

    @DELETE
    @Path(value="/{id}")
    public Response deleteOrganization(@NotNull @PathParam(value="id") String id) {
        Organization organization = (Organization)this.em.find(Organization.class, (Object)id);
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Organization.class);
        Root root = query.from(Organization.class);
        query.select((Selection)root);
        query.where((Expression)builder.equal((Expression)root.get(Organization_.owner), (Object)organization));
        if (this.em.createQuery(query).getResultList().size() > 0) {
            ErrorResponse response = new ErrorResponse("This organization has sub-organizations. Please, remove those before removing this organization.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)response).build();
        }
        if (this.permissionChecker.isAllowedTo(this.operationDelete, id, this.persona)) {
            this.organizationService.deleteOrganization(organization);
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }
}

