/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.backend.boundary;

import java.util.ArrayList;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.hawkular.accounts.api.CurrentUser;
import org.hawkular.accounts.api.OrganizationService;
import org.hawkular.accounts.api.internal.adapter.HawkularAccounts;
import org.hawkular.accounts.api.model.HawkularUser;
import org.hawkular.accounts.api.model.Persona;

@Path(value="/personas")
@PermitAll
@Stateless
public class PersonaEndpoint {
    @Inject
    @HawkularAccounts
    EntityManager em;
    @Inject
    Persona persona;
    @Inject
    @CurrentUser
    HawkularUser user;
    @Inject
    OrganizationService organizationService;

    @GET
    @Path(value="/")
    public Response getPersonas() {
        ArrayList<HawkularUser> personas = new ArrayList<HawkularUser>();
        personas.addAll(this.organizationService.getOrganizationsForPersona((Persona)this.user));
        personas.add(this.user);
        return Response.ok().entity(personas).build();
    }

    @GET
    @Path(value="/current")
    public Response getCurrentPersona() {
        return Response.ok().entity((Object)this.persona).build();
    }
}

