/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.secretstore.boundary;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Principal;
import java.util.UUID;
import javax.annotation.security.PermitAll;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.keycloak.secretstore.api.Token;
import org.keycloak.secretstore.api.TokenService;

@PermitAll
@WebServlet(urlPatterns={"/qrcode"})
public class QRCodeServlet
extends HttpServlet {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    @Inject
    TokenService tokenService;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        BitMatrix bitMatrix;
        UUID tokenId;
        String tokenIdAsString = req.getParameter("tokenId");
        String sizeAsString = req.getParameter("size");
        Principal principal = req.getUserPrincipal();
        int size = 250;
        if (null != sizeAsString && !sizeAsString.isEmpty()) {
            try {
                size = Integer.parseInt(req.getParameter("size"));
            }
            catch (Throwable t) {
                resp.sendError(400, "Size is invalid.");
                return;
            }
        }
        if (null == tokenIdAsString || tokenIdAsString.isEmpty()) {
            resp.sendError(400, "Token key is missing.");
            return;
        }
        try {
            tokenId = UUID.fromString(tokenIdAsString);
        }
        catch (Throwable t) {
            resp.sendError(400, "Token key is invalid.");
            return;
        }
        Token token = this.tokenService.getByIdForDistribution(tokenId);
        if (null == token) {
            resp.sendError(404, "Token could not be found.");
            return;
        }
        if (!principal.getName().equals(token.getPrincipal())) {
            resp.sendError(404, "Token could not be found for principal.");
            return;
        }
        String response = token.getId().toString() + "," + token.getSecret();
        if (null != token.getExpiresAt()) {
            response = response + "," + token.getExpiresAt().toString();
        }
        try {
            QRCodeWriter writer = new QRCodeWriter();
            bitMatrix = writer.encode(response, BarcodeFormat.QR_CODE, size, size);
        }
        catch (WriterException e) {
            resp.sendError(500, "Error while generating the QR Code.");
            return;
        }
        ByteArrayOutputStream pngOut = new ByteArrayOutputStream();
        MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"PNG", (OutputStream)pngOut);
        byte[] pngData = pngOut.toByteArray();
        resp.setStatus(200);
        resp.setContentType("image/png");
        resp.getOutputStream().write(pngData);
    }
}

