/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.sample.control;

import com.datastax.driver.core.Session;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.annotation.security.PermitAll;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.enterprise.concurrent.ManagedExecutorService;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.hawkular.accounts.common.internal.CassandraSessionCallable;
import org.hawkular.accounts.sample.control.HawkularAccountsSample;
import org.hawkular.accounts.sample.control.MsgLogger;

@Startup
@Singleton
@ApplicationScoped
@PermitAll
public class CassandraSessionInitializerForSample {
    MsgLogger logger = MsgLogger.LOGGER;
    private Future<Session> sessionFuture;
    @Resource
    private ManagedExecutorService executor;
    @Inject
    CassandraSessionCallable cassandraSessionCallable;

    @PostConstruct
    public void init() {
        this.sessionFuture = this.executor.submit((Callable)this.cassandraSessionCallable);
    }

    @Produces
    @ApplicationScoped
    @HawkularAccountsSample
    public Session getSession() {
        try {
            Session session = (Session)this.sessionFuture.get();
            InputStream input = this.getClass().getResourceAsStream("/hawkular_accounts_sample.cql");
            try (BufferedReader buffer = new BufferedReader(new InputStreamReader(input));){
                String content = buffer.lines().collect(Collectors.joining("\n"));
                for (String cql : content.split("(?m)^-- #.*$")) {
                    if (cql.startsWith("--")) continue;
                    session.execute(cql);
                }
            }
            catch (Exception e) {
                this.logger.failedToInitializeSchema((Throwable)e);
            }
            return session;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException("Could not get the initialized session.", e);
        }
    }
}

