/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.sample.boundary;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.hawkular.accounts.api.NamedOperation;
import org.hawkular.accounts.api.NamedSetting;
import org.hawkular.accounts.api.PermissionChecker;
import org.hawkular.accounts.api.ResourceService;
import org.hawkular.accounts.api.UserSettingsService;
import org.hawkular.accounts.api.model.Operation;
import org.hawkular.accounts.api.model.Persona;
import org.hawkular.accounts.api.model.Resource;
import org.hawkular.accounts.sample.control.HawkularAccountsSample;
import org.hawkular.accounts.sample.entity.Sample;
import org.hawkular.accounts.sample.entity.SampleRequest;

@Path(value="/samples")
@PermitAll
@Stateless
public class SampleEndpoint {
    @Inject
    Persona currentPersona;
    @Inject
    PermissionChecker permissionChecker;
    @Inject
    ResourceService resourceService;
    @Inject
    @NamedOperation(value="sample-create")
    Operation operationCreate;
    @Inject
    @NamedOperation(value="sample-read")
    Operation operationRead;
    @Inject
    @NamedOperation(value="sample-update")
    Operation operationUpdate;
    @Inject
    @NamedOperation(value="sample-delete")
    Operation operationDelete;
    @Inject
    @NamedSetting(value="hawkular.accounts.sample.getAllSamples")
    String allSamplesQueryPreference;
    @Inject
    UserSettingsService userSettingsService;
    @Inject
    @HawkularAccountsSample
    Session session;

    @GET
    public Response getAllSamples() {
        List rows = this.session.execute("select * from hawkular_accounts.samples").all();
        List asSamples = rows.stream().map(arg_0 -> this.rowToSample(arg_0)).collect(Collectors.toList());
        this.userSettingsService.store("hawkular.accounts.sample.getAllSamples", "WithAllParameters");
        return Response.ok().entity(asSamples).build();
    }

    @GET
    @Path(value="{sampleId}")
    public Response getSample(@PathParam(value="sampleId") String sampleId) {
        PreparedStatement pstmt = this.session.prepare("select * from hawkular_accounts.samples where id = :id");
        Row row = this.session.execute((Statement)pstmt.bind(new Object[]{UUID.fromString(sampleId)})).one();
        Sample sample = this.rowToSample(row);
        if (this.permissionChecker.isAllowedTo(this.operationRead, sample.getId().toString())) {
            return Response.ok().entity((Object)sample).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @POST
    public Response createSample(SampleRequest request) {
        PreparedStatement pstmt = this.session.prepare("insert into hawkular_accounts.samples(id, name, ownerId) values(:id, :name, :ownerId)");
        Sample sample = new Sample(UUID.randomUUID(), this.currentPersona.getIdAsUUID());
        this.resourceService.create(sample.getId().toString(), this.currentPersona);
        sample.setName(request.getName());
        BoundStatement bstmt = new BoundStatement(pstmt);
        bstmt.setUUID("id", sample.getId());
        bstmt.setString("name", sample.getName());
        bstmt.setUUID("ownerId", sample.getOwnerId());
        this.session.execute((Statement)bstmt);
        return Response.ok().entity((Object)sample).build();
    }

    @DELETE
    @Path(value="{sampleId}")
    public Response removeSample(@PathParam(value="sampleId") String sampleId) {
        Resource resource = this.resourceService.get(sampleId);
        if (this.permissionChecker.isAllowedTo(this.operationDelete, resource)) {
            PreparedStatement deleteStmt = this.session.prepare("remove from hawkular_accounts.samples where id = :id");
            this.session.execute((Statement)deleteStmt.bind(new Object[]{UUID.fromString(sampleId)}));
            return Response.noContent().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    public Sample rowToSample(Row row) {
        Sample sample = new Sample(row.getUUID("id"), row.getUUID("ownerId"));
        sample.setName(row.getString("name"));
        return sample;
    }
}

