/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.common.internal;

import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;

@MessageLogger(projectCode="HAWKACC")
@ValidIdRange(min=150000, max=159999)
public interface MsgLogger {
    public static final MsgLogger LOGGER = (MsgLogger)Logger.getMessageLogger(MsgLogger.class, (String)MsgLogger.class.getPackage().getName());

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=150000, value="List of host synonyms provided. Using the list instead of guessing.")
    public void listOfSynonymsProvided();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=150001, value="Bound to wildcard address 0.0.0.0, getting a list of all local IPs for Synonyms")
    public void allLocalAddressesForSynonyms();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=150002, value="Could not process what's the IP for the wildcard host: [%s]")
    public void cannotDetermineIPForWildcardHost(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=150003, value="Could not process what's the IP for the host: [%s]")
    public void cannotDetermineIPForHost(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.FATAL)
    @Message(id=150004, value="Could not process what are our IPs. Host synonyms will *not* work properly")
    public void cannotDetermineLocalIPs(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.FATAL)
    @Message(id=150005, value="Could not connect to Cassandra after enough attempts. Giving up. Reason")
    public void cannotConnectToCassandra(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=150006, value="Cassandra is not available (yet?). Attempts left: [%d]. Reason")
    public void attemptToConnectToCassandraFailed(int var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=150007, value="Cassandra nodes to use: [%s]")
    public void cassandraNodesToUse(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=150008, value="Cassandra port to use: [%s]")
    public void cassandraPortToUse(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=150009, value="Realm configuration: [%s]")
    public void realmConfiguration(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=150010, value="Parsing realm configuration.")
    public void parsingRealmConfiguration();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=150011, value="auth-server-url-for-backend-requests is set, will use it when talking with Keycloak: [%s]")
    public void backendUrlIsSet(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=150012, value="auth-server-url-for-backend-requests is not set. Building it based on information we have.")
    public void backendUrlIsNotSet();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=150013, value="auth-server-url is set. Will use it when talking with Keycloak: [%s]")
    public void authServerUrlIsSet(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=150014, value="Setting auth-server-url set to: [%s]")
    public void settingAuthServerUrl(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=150015, value="Executing an Auth Server request. URL: [%s] , URL Parameters: omitted, Client ID: [%s], Secret: omitted, Method: [%s].")
    public void executingAuthServerRequest(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=150017, value="Request executed. Status code: [%d].")
    public void requestExecuted(int var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=150018, value="Status code is not a success code. Redirecting error stream of the request to our input stream.")
    public void statusCodeNotSuccess();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=150019, value="Status code is a success code. Redirecting input stream of the request to our input stream.")
    public void statusCodeSuccess();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=150020, value="Response body: [%s]")
    public void responseBody(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=150021, value="Attempting to get an access token for username [%s].")
    public void accessTokenForUsername(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=150022, value="Attempting to get a refresh token for username [%s].")
    public void refreshTokenForUsername(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=150023, value="Attempting to get an offline token for username [%s].")
    public void offlineTokenForUsername(String var1);
}

