/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.common;

import java.io.Reader;
import java.io.StringReader;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.servlet.ServletContext;
import org.hawkular.accounts.common.AuthServerUrl;
import org.hawkular.accounts.common.CassandraNodes;
import org.hawkular.accounts.common.CassandraPort;
import org.hawkular.accounts.common.RealmConfiguration;
import org.hawkular.accounts.common.RealmName;
import org.hawkular.accounts.common.RealmResourceName;
import org.hawkular.accounts.common.RealmResourceSecret;
import org.hawkular.accounts.common.internal.MsgLogger;

@ApplicationScoped
public class ApplicationResources {
    MsgLogger logger = MsgLogger.LOGGER;
    private static final String REALM_CONFIG_KEY = "org.keycloak.json.adapterConfig";
    private String realmConfiguration = null;
    private ServletContext servletContext;
    private boolean realmConfigurationParsed = false;
    private String realmName;
    private String serverUrl;
    private String resourceName;
    private String secret;
    private String cassandraPort;
    private String cassandraNodes;

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Produces
    @CassandraNodes
    public String getCassandraNodes() {
        if (null == this.cassandraNodes) {
            this.cassandraNodes = System.getenv("CASSANDRA_NODES");
            if (null == this.cassandraNodes || this.cassandraNodes.isEmpty()) {
                this.cassandraNodes = "127.0.0.1";
            }
            this.logger.cassandraNodesToUse(this.cassandraNodes);
        }
        return this.cassandraNodes;
    }

    @Produces
    @CassandraPort
    public String getCassandraPort() {
        if (null == this.cassandraPort) {
            this.cassandraPort = System.getenv("CASSANDRA_CQL_PORT");
            if (null == this.cassandraPort || this.cassandraPort.isEmpty()) {
                this.cassandraPort = "9042";
            }
            this.logger.cassandraPortToUse(this.cassandraPort);
        }
        return this.cassandraPort;
    }

    @Produces
    @RealmConfiguration
    public String getRealmConfiguration() {
        if (null == this.realmConfiguration) {
            this.realmConfiguration = this.servletContext.getInitParameter(REALM_CONFIG_KEY);
            this.logger.realmConfiguration(this.realmConfiguration);
        }
        return this.realmConfiguration;
    }

    @Produces
    @RealmName
    public String getRealmName() {
        if (!this.realmConfigurationParsed) {
            this.parseRealmConfiguration();
        }
        return this.realmName;
    }

    @Produces
    @AuthServerUrl
    public String getServerUrl() {
        if (!this.realmConfigurationParsed) {
            this.parseRealmConfiguration();
        }
        return this.serverUrl;
    }

    @Produces
    @RealmResourceName
    public String getResourceName() {
        if (!this.realmConfigurationParsed) {
            this.parseRealmConfiguration();
        }
        return this.resourceName;
    }

    @Produces
    @RealmResourceSecret
    public String getResourceNameSecret() {
        if (!this.realmConfigurationParsed) {
            this.parseRealmConfiguration();
        }
        return this.secret;
    }

    private void parseRealmConfiguration() {
        this.logger.parsingRealmConfiguration();
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(this.getRealmConfiguration()));
        JsonObject configurationJson = jsonReader.readObject();
        JsonObject credentials = configurationJson.getJsonObject("credentials");
        this.realmName = configurationJson.getString("realm");
        this.resourceName = configurationJson.getString("resource");
        this.secret = credentials.getString("secret");
        if (configurationJson.containsKey((Object)"auth-server-url-for-backend-requests")) {
            this.serverUrl = configurationJson.getString("auth-server-url-for-backend-requests");
            this.logger.backendUrlIsSet(this.serverUrl);
        } else {
            this.logger.backendUrlIsNotSet();
            String authContextPath = "/auth";
            if (configurationJson.containsKey((Object)"auth-server-url")) {
                authContextPath = configurationJson.getString("auth-server-url");
                this.logger.authServerUrlIsSet(authContextPath);
            }
            if (authContextPath.toLowerCase().startsWith("http")) {
                this.serverUrl = authContextPath;
            } else {
                int portOffset = Integer.parseInt(System.getProperty("jboss.socket.binding.port-offset", "0"));
                int defaultPort = Integer.parseInt(System.getProperty("jboss.http.port", "8080"));
                String host = System.getProperty("jboss.bind.address", "127.0.0.1");
                this.serverUrl = "http://" + host + ":" + (defaultPort + portOffset) + authContextPath;
            }
            this.logger.settingAuthServerUrl(this.serverUrl);
        }
        this.realmConfigurationParsed = true;
    }
}

