/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.common.internal;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import org.hawkular.accounts.common.AuthServerHostSynonymService;
import org.hawkular.accounts.common.internal.MsgLogger;

@ApplicationScoped
public class AuthServerHostSynonymServiceImpl
implements AuthServerHostSynonymService {
    private MsgLogger logger = MsgLogger.LOGGER;
    private static final String WILDCARD_ADDRESS = "0.0.0.0";
    private static final String DEFAULT_ADDRESS = "127.0.0.1";
    private boolean bestEffort = true;
    private Set<String> hostSynonyms;
    private Map<String, Boolean> hostnameCache;
    private Set<InetAddress> localIPs;
    private String synonyms;
    private String boundToAddress;

    public AuthServerHostSynonymServiceImpl() {
        this.synonyms = System.getProperty("org.hawkular.accounts.auth.host.synonyms");
        this.boundToAddress = System.getProperty("jboss.bind.address");
    }

    public AuthServerHostSynonymServiceImpl(String synonyms, String boundToAddress) {
        this.synonyms = synonyms;
        this.boundToAddress = boundToAddress;
    }

    @PostConstruct
    void determineHostSynonyms() {
        InetAddress[] addressForHost;
        if (this.synonyms != null && !this.synonyms.isEmpty()) {
            this.hostSynonyms = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(this.synonyms.split(","))));
            this.bestEffort = false;
            this.logger.listOfSynonymsProvided();
            return;
        }
        this.localIPs = new HashSet<InetAddress>();
        this.hostnameCache = new HashMap<String, Boolean>();
        if (this.boundToAddress == null || this.boundToAddress.isEmpty()) {
            this.boundToAddress = DEFAULT_ADDRESS;
        }
        if (WILDCARD_ADDRESS.equals(this.boundToAddress)) {
            this.logger.allLocalAddressesForSynonyms();
            this.determineLocalAddresses();
            try {
                this.localIPs.add(InetAddress.getByName(WILDCARD_ADDRESS));
            }
            catch (UnknownHostException e) {
                this.logger.cannotDetermineIPForWildcardHost(WILDCARD_ADDRESS);
            }
            return;
        }
        try {
            addressForHost = InetAddress.getAllByName(this.boundToAddress);
        }
        catch (UnknownHostException e) {
            this.logger.cannotDetermineIPForHost(WILDCARD_ADDRESS, e);
            return;
        }
        Collections.addAll(this.localIPs, addressForHost);
    }

    @Override
    public boolean isHostSynonym(String host) {
        if (!this.bestEffort) {
            return this.hostSynonyms.contains(host);
        }
        if (this.hostnameCache.containsKey(host)) {
            return this.hostnameCache.get(host);
        }
        return this.checkNewHost(host);
    }

    boolean checkNewHost(String host) {
        InetAddress[] addressForHost;
        try {
            addressForHost = InetAddress.getAllByName(host);
        }
        catch (UnknownHostException e) {
            return false;
        }
        boolean found = false;
        for (InetAddress address : addressForHost) {
            if (!this.localIPs.contains(address)) continue;
            found = true;
        }
        this.hostnameCache.put(host, found);
        return found;
    }

    void determineLocalAddresses() {
        Enumeration<NetworkInterface> networkInterfaceEnumeration = this.getNetworkInterfaces();
        while (networkInterfaceEnumeration.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaceEnumeration.nextElement();
            Enumeration<InetAddress> addressEnumeration = networkInterface.getInetAddresses();
            while (addressEnumeration.hasMoreElements()) {
                InetAddress address = addressEnumeration.nextElement();
                this.localIPs.add(address);
            }
        }
    }

    Set<InetAddress> getLocalIPs() {
        if (null == this.localIPs) {
            return null;
        }
        return Collections.unmodifiableSet(this.localIPs);
    }

    Enumeration<NetworkInterface> getNetworkInterfaces() {
        try {
            return NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            this.logger.cannotDetermineLocalIPs(e);
            throw new RuntimeException(e);
        }
    }
}

