/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.common;

import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.servlet.ServletContext;
import org.hawkular.accounts.common.AuthServerUrl;
import org.hawkular.accounts.common.HostSynonyms;
import org.hawkular.accounts.common.RealmConfiguration;
import org.hawkular.accounts.common.RealmName;
import org.hawkular.accounts.common.RealmResourceName;
import org.hawkular.accounts.common.RealmResourceSecret;

@ApplicationScoped
public class ApplicationResources {
    private static final String REALM_CONFIG_KEY = "org.keycloak.json.adapterConfig";
    private String realmConfiguration = null;
    private ServletContext servletContext;
    private boolean realmConfigurationParsed = false;
    private String realmName;
    private String serverUrl;
    private String resourceName;
    private String secret;
    private Set<String> hostSynonyms;

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Produces
    @RealmConfiguration
    public String getRealmConfiguration() {
        if (null == this.realmConfiguration) {
            this.realmConfiguration = this.servletContext.getInitParameter(REALM_CONFIG_KEY);
        }
        return this.realmConfiguration;
    }

    @Produces
    @RealmName
    public String getRealmName() {
        if (!this.realmConfigurationParsed) {
            this.parseRealmConfiguration();
        }
        return this.realmName;
    }

    @Produces
    @AuthServerUrl
    public String getServerUrl() {
        if (!this.realmConfigurationParsed) {
            this.parseRealmConfiguration();
        }
        return this.serverUrl;
    }

    @Produces
    @RealmResourceName
    public String getResourceName() {
        if (!this.realmConfigurationParsed) {
            this.parseRealmConfiguration();
        }
        return this.resourceName;
    }

    @Produces
    @RealmResourceSecret
    public String getResourceNameSecret() {
        if (!this.realmConfigurationParsed) {
            this.parseRealmConfiguration();
        }
        return this.secret;
    }

    @Produces
    @HostSynonyms
    public Set<String> getHostSynonyms() {
        if (this.hostSynonyms == null) {
            String synonyms = System.getProperty("org.hawkular.accounts.host.synonyms", "localhost,127.0.0.1,0.0.0.0");
            this.hostSynonyms = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(synonyms.split(","))));
        }
        return this.hostSynonyms;
    }

    private void parseRealmConfiguration() {
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(this.getRealmConfiguration()));
        JsonObject configurationJson = jsonReader.readObject();
        JsonObject credentials = configurationJson.getJsonObject("credentials");
        this.realmName = configurationJson.getString("realm");
        this.serverUrl = configurationJson.getString("auth-server-url-for-backend-requests");
        this.resourceName = configurationJson.getString("resource");
        this.secret = credentials.getString("secret");
        this.realmConfigurationParsed = true;
    }
}

