/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.model;

import java.time.ZonedDateTime;
import java.util.UUID;
import org.hawkular.accounts.api.model.BaseEntity;
import org.hawkular.accounts.api.model.Persona;

public class Resource
extends BaseEntity {
    private Persona persona;
    private Resource parent = null;

    public Resource(Persona persona) {
        this.setPersona(persona);
    }

    public Resource(Resource parent) {
        this.setParent(parent);
    }

    public Resource(Persona persona, Resource parent) {
        if (null == persona && null == parent) {
            throw new IllegalStateException("A resource should either have a valid parent or an owner.");
        }
        this.persona = persona;
        this.parent = parent;
    }

    public Resource(String id, Resource parent) {
        super(id);
        this.setParent(parent);
    }

    public Resource(String id, Persona persona) {
        super(id);
        this.setPersona(persona);
    }

    public Resource(String id, Persona persona, Resource parent) {
        super(id);
        if (null == persona && null == parent) {
            throw new IllegalStateException("A resource should either have a valid parent or an owner.");
        }
        this.persona = persona;
        this.parent = parent;
    }

    public Resource(UUID id, ZonedDateTime createdAt, ZonedDateTime updatedAt, Persona persona, Resource parent) {
        super(id, createdAt, updatedAt);
        this.persona = persona;
        this.parent = parent;
    }

    public Persona getPersona() {
        return this.persona;
    }

    public Resource getParent() {
        return this.parent;
    }

    public void setParent(Resource parent) {
        if (null == parent && null == this.persona) {
            throw new IllegalStateException("A resource should either have a valid parent or an owner.");
        }
        this.parent = parent;
    }

    public void setPersona(Persona persona) {
        if (null == persona && null == this.parent) {
            throw new IllegalStateException("A resource should either have a valid parent or an owner.");
        }
        this.persona = persona;
    }

    public static class Builder
    extends BaseEntity.Builder {
        private Persona persona;
        private Resource parent;

        public Builder persona(Persona persona) {
            this.persona = persona;
            return this;
        }

        public Builder parent(Resource parent) {
            this.parent = parent;
            return this;
        }

        public Resource build() {
            return new Resource(this.id, this.createdAt, this.updatedAt, this.persona, this.parent);
        }
    }
}

