/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.internal.impl;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.hawkular.accounts.api.InvitationService;
import org.hawkular.accounts.api.NamedRole;
import org.hawkular.accounts.api.OrganizationJoinRequestService;
import org.hawkular.accounts.api.OrganizationMembershipService;
import org.hawkular.accounts.api.OrganizationService;
import org.hawkular.accounts.api.PersonaService;
import org.hawkular.accounts.api.ResourceService;
import org.hawkular.accounts.api.internal.BoundStatements;
import org.hawkular.accounts.api.internal.NamedStatement;
import org.hawkular.accounts.api.internal.impl.BaseServiceImpl;
import org.hawkular.accounts.api.internal.impl.MsgLogger;
import org.hawkular.accounts.api.model.Invitation;
import org.hawkular.accounts.api.model.JoinRequestStatus;
import org.hawkular.accounts.api.model.Organization;
import org.hawkular.accounts.api.model.OrganizationJoinRequest;
import org.hawkular.accounts.api.model.OrganizationMembership;
import org.hawkular.accounts.api.model.Persona;
import org.hawkular.accounts.api.model.Resource;
import org.hawkular.accounts.api.model.Role;
import org.hawkular.accounts.api.model.Visibility;

@Stateless
@PermitAll
public class OrganizationServiceImpl
extends BaseServiceImpl<Organization>
implements OrganizationService {
    MsgLogger logger = MsgLogger.LOGGER;
    @Inject
    OrganizationMembershipService membershipService;
    @Inject
    ResourceService resourceService;
    @Inject
    InvitationService invitationService;
    @Inject
    OrganizationJoinRequestService joinRequestService;
    @Inject
    PersonaService personaService;
    @Inject
    @NamedRole(value="SuperUser")
    Role superUser;
    @Inject
    @NamedStatement(value=BoundStatements.ORGANIZATION_GET_BY_ID)
    Instance<BoundStatement> stmtGetByIdInstance;
    @Inject
    @NamedStatement(value=BoundStatements.ORGANIZATION_GET_APPLY)
    Instance<BoundStatement> stmtGetApplyInstance;
    @Inject
    @NamedStatement(value=BoundStatements.ORGANIZATION_GET_BY_NAME)
    Instance<BoundStatement> stmtGetByNameInstance;
    @Inject
    @NamedStatement(value=BoundStatements.ORGANIZATION_GET_BY_OWNER)
    Instance<BoundStatement> stmtGetByOwnerInstance;
    @Inject
    @NamedStatement(value=BoundStatements.ORGANIZATION_CREATE)
    Instance<BoundStatement> stmtCreateInstance;
    @Inject
    @NamedStatement(value=BoundStatements.ORGANIZATION_REMOVE)
    Instance<BoundStatement> stmtRemoveInstance;
    @Inject
    @NamedStatement(value=BoundStatements.ORGANIZATION_TRANSFER)
    Instance<BoundStatement> stmtTransferInstance;

    @Override
    public Organization getById(UUID id) {
        if (null == id) {
            throw new IllegalArgumentException("The given organization ID is invalid (null).");
        }
        return (Organization)this.getById(id, (BoundStatement)this.stmtGetByIdInstance.get());
    }

    @Override
    public Organization getByName(String name) {
        BoundStatement stmtGetByName = (BoundStatement)this.stmtGetByNameInstance.get();
        if (null == name) {
            throw new IllegalArgumentException("The given organization name is invalid (null).");
        }
        stmtGetByName.setString("name", name);
        return (Organization)this.getSingleRecord(stmtGetByName);
    }

    @Override
    public Organization get(String id) {
        return this.getById(UUID.fromString(id));
    }

    @Override
    public List<Organization> getFilteredOrganizationsToJoin(Persona persona) {
        List<Organization> organizationsJoined = this.getOrganizationsForPersona(persona);
        this.logger.organizationsPersonaJoined(persona.getId(), organizationsJoined.size());
        List<Organization> organizationsToJoin = this.getOrganizationsToJoin();
        this.logger.organizationsPersonaToJoin(persona.getId(), organizationsToJoin.size());
        List<OrganizationJoinRequest> joinRequestsForPersona = this.joinRequestService.getAllRequestsForPersona(persona);
        this.logger.personaJoinRequests(persona.getId(), joinRequestsForPersona.size());
        List organizationsApplied = joinRequestsForPersona.stream().filter(j -> j.getStatus() == JoinRequestStatus.PENDING).map(OrganizationJoinRequest::getOrganization).distinct().collect(Collectors.toList());
        this.logger.personaJoinRequestsPending(persona.getId(), organizationsApplied.size());
        organizationsToJoin.removeAll(organizationsJoined);
        organizationsToJoin.removeAll(organizationsApplied);
        this.logger.organizationsPersonaToJoinFiltered(persona.getId(), organizationsToJoin.size());
        return organizationsToJoin;
    }

    @Override
    public List<Organization> getOrganizationsToJoin() {
        return this.getFromRows(this.session.execute((Statement)this.stmtGetApplyInstance.get()).all());
    }

    @Override
    public List<Organization> getOrganizationsForPersona(Persona persona) {
        return this.getOrganizationsFromMemberships(this.membershipService.getMembershipsForPersona(persona));
    }

    @Override
    public List<Organization> getOrganizationsFromMemberships(List<OrganizationMembership> memberships) {
        return memberships.stream().map(OrganizationMembership::getOrganization).distinct().collect(Collectors.toList());
    }

    @Override
    public Organization createOrganization(String name, String description, Persona owner) {
        return this.createOrganization(name, description, Visibility.PRIVATE, owner);
    }

    @Override
    public Organization createOrganization(String name, String description, Visibility visibility, Persona owner) {
        BoundStatement stmtCreate = (BoundStatement)this.stmtCreateInstance.get();
        if (null != this.getByName(name)) {
            throw new IllegalArgumentException("There's already an organization with this name.");
        }
        Organization organization = new Organization(owner);
        organization.setName(name);
        organization.setDescription(description);
        organization.setVisibility(visibility);
        Resource resource = this.resourceService.create(organization.getId(), owner);
        this.resourceService.addRoleToPersona(resource, owner, this.superUser);
        this.bindBasicParameters(organization, stmtCreate);
        stmtCreate.setString("name", organization.getName());
        stmtCreate.setString("description", organization.getDescription());
        stmtCreate.setUUID("owner", organization.getOwner().getIdAsUUID());
        stmtCreate.setString("visibility", organization.getVisibility().name());
        this.session.execute((Statement)stmtCreate);
        this.membershipService.create(organization, owner, this.superUser);
        this.resourceService.addRoleToPersona(resource, organization, this.superUser);
        this.logger.organizationCreated(organization.getName(), organization.getId());
        return organization;
    }

    @Override
    public void deleteOrganization(Organization organization) {
        this.logger.startingRemovalOfOrganization(organization.getId());
        Resource resource = this.resourceService.get(organization.getId());
        this.invitationService.getInvitationsForOrganization(organization).stream().forEach(invitation -> {
            if (null != invitation.getAcceptedBy()) {
                this.resourceService.revokeAllForPersona(resource, invitation.getAcceptedBy());
            }
            this.invitationService.remove((Invitation)invitation);
        });
        this.joinRequestService.getAllRequestsForOrganization(organization).stream().forEach(request -> {
            if (request.getStatus().equals((Object)JoinRequestStatus.ACCEPTED)) {
                this.resourceService.revokeAllForPersona(resource, request.getPersona());
            }
            this.joinRequestService.remove((OrganizationJoinRequest)request);
        });
        this.membershipService.getMembershipsForOrganization(organization).stream().forEach(this.membershipService::remove);
        this.resourceService.revokeAllForPersona(resource, organization.getOwner());
        this.resourceService.delete(organization.getId());
        this.session.execute((Statement)((BoundStatement)this.stmtRemoveInstance.get()).setUUID("id", organization.getIdAsUUID()));
        this.logger.finishedRemovalOfOrganization(organization.getId());
    }

    @Override
    public void transfer(Organization organization, Persona newOwner) {
        this.logger.startingTransferOfOrganization(organization.getId(), organization.getOwner().getId(), newOwner.getId());
        BoundStatement stmtTransfer = (BoundStatement)this.stmtTransferInstance.get();
        this.membershipService.getPersonaMembershipsForOrganization(newOwner, organization).stream().forEach(this.membershipService::remove);
        this.membershipService.create(organization, newOwner, this.superUser);
        Resource resource = this.resourceService.getById(organization.getIdAsUUID());
        this.resourceService.transfer(resource, newOwner);
        organization.setOwner(newOwner);
        stmtTransfer.setUUID("owner", organization.getOwner().getIdAsUUID());
        this.session.execute((Statement)stmtTransfer);
        this.logger.finishedTransferOfOrganization(organization.getId(), organization.getOwner().getId(), newOwner.getId());
    }

    @Override
    public List<Organization> getSubOrganizations(Organization organization) {
        return this.getList(((BoundStatement)this.stmtGetByOwnerInstance.get()).setUUID("owner", organization.getIdAsUUID()));
    }

    @Override
    Organization getFromRow(Row row) {
        Persona owner = this.personaService.getById(row.getUUID("owner"));
        String name = row.getString("name");
        String description = row.getString("description");
        String visibility = row.getString("visibility");
        Organization.Builder builder = new Organization.Builder();
        this.mapBaseFields(row, builder);
        return builder.owner(owner).name(name).description(description).visibility(visibility).build();
    }
}

