/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.model;

import java.time.ZonedDateTime;
import java.util.UUID;
import org.hawkular.accounts.api.model.BaseEntity;
import org.hawkular.accounts.api.model.HawkularUser;
import org.hawkular.accounts.api.model.Organization;
import org.hawkular.accounts.api.model.Role;

public class Invitation
extends BaseEntity {
    private String email;
    private ZonedDateTime acceptedAt = null;
    private ZonedDateTime dispatchedAt = null;
    private HawkularUser invitedBy;
    private HawkularUser acceptedBy;
    private Organization organization;
    private Role role;

    public Invitation(String email, HawkularUser invitedBy, Organization organization, Role role) {
        this.email = email;
        this.invitedBy = invitedBy;
        this.organization = organization;
        this.role = role;
    }

    public Invitation(String id, String email, HawkularUser invitedBy, Organization organization, Role role) {
        super(id);
        this.email = email;
        this.invitedBy = invitedBy;
        this.organization = organization;
        this.role = role;
    }

    public Invitation(UUID id, ZonedDateTime createdAt, ZonedDateTime updatedAt, String email, ZonedDateTime acceptedAt, ZonedDateTime dispatchedAt, HawkularUser invitedBy, HawkularUser acceptedBy, Organization organization, Role role) {
        super(id, createdAt, updatedAt);
        this.email = email;
        this.acceptedAt = acceptedAt;
        this.dispatchedAt = dispatchedAt;
        this.invitedBy = invitedBy;
        this.acceptedBy = acceptedBy;
        this.organization = organization;
        this.role = role;
    }

    public String getToken() {
        return this.getId();
    }

    public HawkularUser getInvitedBy() {
        return this.invitedBy;
    }

    public Organization getOrganization() {
        return this.organization;
    }

    public Role getRole() {
        return this.role;
    }

    public String getEmail() {
        return this.email;
    }

    public ZonedDateTime getAcceptedAt() {
        return this.acceptedAt;
    }

    public void setAcceptedAt(ZonedDateTime acceptedAt) {
        this.acceptedAt = acceptedAt;
    }

    public ZonedDateTime getDispatchedAt() {
        return this.dispatchedAt;
    }

    public void setDispatchedAt(ZonedDateTime dispatchedAt) {
        this.dispatchedAt = dispatchedAt;
    }

    public void setAccepted() {
        this.acceptedAt = ZonedDateTime.now();
    }

    public void setDispatched() {
        this.dispatchedAt = ZonedDateTime.now();
    }

    public HawkularUser getAcceptedBy() {
        return this.acceptedBy;
    }

    public void setAcceptedBy(HawkularUser acceptedBy) {
        this.acceptedBy = acceptedBy;
    }

    public static class Builder
    extends BaseEntity.Builder {
        private String email;
        private ZonedDateTime acceptedAt;
        private ZonedDateTime dispatchedAt;
        private HawkularUser invitedBy;
        private HawkularUser acceptedBy;
        private Organization organization;
        private Role role;

        public Builder email(String email) {
            this.email = email;
            return this;
        }

        public Builder acceptedAt(ZonedDateTime acceptedAt) {
            this.acceptedAt = acceptedAt;
            return this;
        }

        public Builder dispatchedAt(ZonedDateTime dispatchedAt) {
            this.dispatchedAt = dispatchedAt;
            return this;
        }

        public Builder invitedBy(HawkularUser invitedBy) {
            this.invitedBy = invitedBy;
            return this;
        }

        public Builder acceptedBy(HawkularUser acceptedBy) {
            this.acceptedBy = acceptedBy;
            return this;
        }

        public Builder organization(Organization organization) {
            this.organization = organization;
            return this;
        }

        public Builder role(Role role) {
            this.role = role;
            return this;
        }

        public Invitation build() {
            return new Invitation(this.id, this.createdAt, this.updatedAt, this.email, this.acceptedAt, this.dispatchedAt, this.invitedBy, this.acceptedBy, this.organization, this.role);
        }
    }
}

