/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.internal.impl;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import java.security.InvalidParameterException;
import java.util.Set;
import java.util.UUID;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.hawkular.accounts.api.NamedOperation;
import org.hawkular.accounts.api.OperationService;
import org.hawkular.accounts.api.PermissionService;
import org.hawkular.accounts.api.RoleService;
import org.hawkular.accounts.api.internal.BoundStatements;
import org.hawkular.accounts.api.internal.NamedStatement;
import org.hawkular.accounts.api.internal.impl.BaseServiceImpl;
import org.hawkular.accounts.api.model.Operation;
import org.hawkular.accounts.api.model.Permission;
import org.hawkular.accounts.api.model.Role;

@Stateless
@PermitAll
public class OperationServiceImpl
extends BaseServiceImpl<Operation>
implements OperationService {
    @Inject
    PermissionService permissionService;
    @Inject
    RoleService roleService;
    @Inject
    @NamedStatement(value=BoundStatements.OPERATION_GET_BY_NAME)
    Instance<BoundStatement> stmtGetByNameInstance;
    @Inject
    @NamedStatement(value=BoundStatements.OPERATION_GET_BY_ID)
    Instance<BoundStatement> stmtGetByIdInstance;
    @Inject
    @NamedStatement(value=BoundStatements.OPERATION_CREATE)
    Instance<BoundStatement> stmtCreateInstance;

    @Override
    public Operation getByName(String name) {
        BoundStatement stmtGetByName = (BoundStatement)this.stmtGetByNameInstance.get();
        stmtGetByName.setString("name", name);
        return (Operation)this.getSingleRecord(stmtGetByName);
    }

    @Override
    public Operation getById(UUID id) {
        return (Operation)this.getById(id, (BoundStatement)this.stmtGetByIdInstance.get());
    }

    @Override
    @Produces
    @NamedOperation
    public Operation produceOperationByName(InjectionPoint injectionPoint) {
        NamedOperation namedOperation = (NamedOperation)injectionPoint.getAnnotated().getAnnotation(NamedOperation.class);
        String operationName = namedOperation.value();
        return this.getByName(operationName);
    }

    @Override
    public Setup setup(Operation operation) {
        return new Setup(operation);
    }

    @Override
    public Setup setup(String operationName) {
        Operation operation = this.getByName(operationName);
        if (null == operation) {
            operation = this.create(operationName);
        }
        return this.setup(operation);
    }

    @Override
    Operation getFromRow(Row row) {
        Operation.Builder builder = new Operation.Builder();
        this.mapBaseFields(row, builder);
        return builder.name(row.getString("name")).build();
    }

    Operation create(String name) {
        BoundStatement stmtCreate = (BoundStatement)this.stmtCreateInstance.get();
        if (null != this.getByName(name)) {
            throw new InvalidParameterException("There's already an operation with the given name.");
        }
        Operation operation = new Operation(name);
        this.bindBasicParameters(operation, stmtCreate);
        stmtCreate.setString("name", name);
        this.session.execute((Statement)stmtCreate);
        return operation;
    }

    Operation getOrCreateByName(String name) {
        Operation byName = this.getByName(name);
        if (null != byName) {
            return byName;
        }
        return this.create(name);
    }

    public class Setup
    implements OperationService.Setup {
        private Operation operation;
        private Set<Role> roles;
        private boolean rolesHaveChanged = false;

        private Setup(Operation operation) {
            this.operation = operation;
            this.roles = OperationServiceImpl.this.permissionService.getPermittedRoles(operation);
        }

        @Override
        public OperationService.Setup add(Role role) {
            if (null == role) {
                throw new IllegalArgumentException("The given role is invalid (null).");
            }
            if (!this.roles.contains(role)) {
                Set<Role> implicitRoles = OperationServiceImpl.this.roleService.getImplicitPermittedRoles(role);
                this.rolesHaveChanged = true;
                this.roles.addAll(implicitRoles);
                this.roles.add(role);
            }
            return this;
        }

        @Override
        public OperationService.Setup add(String roleName) {
            return this.add(OperationServiceImpl.this.roleService.getByName(roleName));
        }

        @Override
        public OperationService.Setup add(Role role1, Role role2) {
            return this.add(role1).add(role2);
        }

        @Override
        public OperationService.Setup add(Role role1, Role role2, Role role3) {
            return this.add(role1).add(role2).add(role3);
        }

        @Override
        public OperationService.Setup add(Role ... roles) {
            for (Role role : roles) {
                this.add(role);
            }
            return this;
        }

        @Override
        public OperationService.Setup clear() {
            this.rolesHaveChanged = true;
            this.roles.clear();
            return this;
        }

        @Override
        public OperationService persist() {
            this.doPersist();
            return OperationServiceImpl.this;
        }

        @Override
        public Operation make() {
            this.doPersist();
            return this.operation;
        }

        private void doPersist() {
            if (this.rolesHaveChanged) {
                Set<Permission> permissions = OperationServiceImpl.this.permissionService.getPermissionsForOperation(this.operation);
                permissions.forEach(OperationServiceImpl.this.permissionService::remove);
                this.roles.forEach(role -> OperationServiceImpl.this.permissionService.create(this.operation, (Role)role));
            }
        }
    }
}

