/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.model;

import java.time.ZonedDateTime;
import java.util.UUID;
import org.hawkular.accounts.api.model.BaseEntity;
import org.hawkular.accounts.api.model.Operation;
import org.hawkular.accounts.api.model.Role;

public class Permission
extends BaseEntity {
    private Operation operation;
    private Role role;

    public Permission(Operation operation, Role role) {
        this.operation = operation;
        this.role = role;
    }

    public Permission(String id, Operation operation, Role role) {
        super(id);
        this.operation = operation;
        this.role = role;
    }

    public Permission(UUID id, ZonedDateTime createdAt, ZonedDateTime updatedAt, Operation operation, Role role) {
        super(id, createdAt, updatedAt);
        this.operation = operation;
        this.role = role;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public Role getRole() {
        return this.role;
    }

    @Override
    public String toString() {
        return "Permission{operation=" + this.operation + ", role=" + this.role + ", base='" + super.toString() + '\'' + '}';
    }

    public static class Builder
    extends BaseEntity.Builder {
        private Operation operation;
        private Role role;

        public Builder operation(Operation operation) {
            this.operation = operation;
            return this;
        }

        public Builder role(Role role) {
            this.role = role;
            return this;
        }

        public Permission build() {
            return new Permission(this.id, this.createdAt, this.updatedAt, this.operation, this.role);
        }
    }
}

