/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.internal.impl;

import java.util.Set;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.hawkular.accounts.api.PermissionChecker;
import org.hawkular.accounts.api.PermissionService;
import org.hawkular.accounts.api.PersonaService;
import org.hawkular.accounts.api.ResourceService;
import org.hawkular.accounts.api.internal.impl.MsgLogger;
import org.hawkular.accounts.api.model.Operation;
import org.hawkular.accounts.api.model.Persona;
import org.hawkular.accounts.api.model.Resource;
import org.hawkular.accounts.api.model.Role;

@Stateless
@PermitAll
public class PermissionCheckerImpl
implements PermissionChecker {
    MsgLogger logger = MsgLogger.LOGGER;
    @Inject
    PermissionService permissionService;
    @Inject
    PersonaService personaService;
    @Inject
    ResourceService resourceService;
    @Inject
    Instance<Persona> personaInstance;

    @Override
    public boolean isAllowedTo(Operation operation, Resource resource, Persona persona) {
        if (null == resource) {
            throw new IllegalArgumentException("Resource to be checked is invalid (null).");
        }
        if (null == operation) {
            throw new IllegalArgumentException("Operation to be checked is invalid (null).");
        }
        if (null == persona) {
            throw new IllegalArgumentException("Persona that performs the operation is invalid (null).");
        }
        this.logger.checkPermission(persona.getId(), operation.getName(), resource.getId());
        if (null == resource.getPersona()) {
            this.logger.checkingParentsPermission(resource.getId(), resource.getParent().getId());
            return this.isAllowedTo(operation, resource.getParent(), persona);
        }
        if (persona.equals(resource.getPersona())) {
            this.logger.permissionGrantedToOwner(operation.getName(), resource.getId(), persona.getId());
            return true;
        }
        Set<Role> permittedRoles = this.permissionService.getPermittedRoles(operation);
        this.logger.operationPermittedToRoles(operation.getName(), permittedRoles.size());
        Set<Role> personaRoles = this.personaService.getEffectiveRolesForResource(persona, resource);
        this.logger.personaHasRoles(persona.getId(), permittedRoles.size());
        boolean allowed = personaRoles.stream().anyMatch(permittedRoles::contains);
        this.logger.checkPermissionResult(persona.getId(), operation.getName(), resource.getId(), allowed);
        return allowed;
    }

    @Override
    public boolean isAllowedTo(Operation operation, String resourceId, Persona persona) {
        Resource resource = this.resourceService.get(resourceId);
        return this.isAllowedTo(operation, resource, persona);
    }

    @Override
    public boolean isAllowedTo(Operation operation, Resource resource) {
        return this.isAllowedTo(operation, resource, (Persona)this.personaInstance.get());
    }

    @Override
    public boolean isAllowedTo(Operation operation, String resourceId) {
        Resource resource = this.resourceService.get(resourceId);
        return this.isAllowedTo(operation, resource);
    }
}

