/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.internal.impl;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.hawkular.accounts.api.OperationService;
import org.hawkular.accounts.api.PermissionService;
import org.hawkular.accounts.api.RoleService;
import org.hawkular.accounts.api.internal.BoundStatements;
import org.hawkular.accounts.api.internal.NamedStatement;
import org.hawkular.accounts.api.internal.impl.BaseServiceImpl;
import org.hawkular.accounts.api.model.Operation;
import org.hawkular.accounts.api.model.Permission;
import org.hawkular.accounts.api.model.Role;

@Stateless
@PermitAll
public class PermissionServiceImpl
extends BaseServiceImpl<Permission>
implements PermissionService {
    @Inject
    OperationService operationService;
    @Inject
    RoleService roleService;
    @Inject
    @NamedStatement(value=BoundStatements.PERMISSION_GET_BY_ID)
    BoundStatement getById;
    @Inject
    @NamedStatement(value=BoundStatements.PERMISSION_DELETE)
    BoundStatement deleteStatement;
    @Inject
    @NamedStatement(value=BoundStatements.PERMISSIONS_GET_BY_OPERATION)
    BoundStatement getByOperation;
    @Inject
    @NamedStatement(value=BoundStatements.PERMISSION_CREATE)
    BoundStatement createStatement;

    @Override
    public Set<Role> getPermittedRoles(Operation operation) {
        return this.getPermissionsForOperation(operation).stream().map(Permission::getRole).collect(Collectors.toSet());
    }

    @Override
    public Set<Permission> getPermissionsForOperation(Operation operation) {
        this.getByOperation.setUUID("operation", operation.getIdAsUUID());
        return this.getList(this.getByOperation).stream().collect(Collectors.toSet());
    }

    @Override
    public Permission getById(UUID id) {
        return (Permission)this.getById(id, this.getById);
    }

    @Override
    public Permission create(Operation operation, Role role) {
        Permission permission = new Permission(operation, role);
        this.bindBasicParameters(permission, this.createStatement);
        this.createStatement.setUUID("operation", permission.getOperation().getIdAsUUID());
        this.createStatement.setUUID("role", permission.getRole().getIdAsUUID());
        this.session.execute((Statement)this.createStatement);
        return permission;
    }

    @Override
    public void remove(Permission permission) {
        this.deleteStatement.setUUID("id", permission.getIdAsUUID());
        this.session.execute((Statement)this.deleteStatement);
    }

    @Override
    Permission getFromRow(Row row) {
        Operation operation = this.operationService.getById(row.getUUID("operation"));
        Role role = this.roleService.getById(row.getUUID("role"));
        Permission.Builder builder = new Permission.Builder();
        super.mapBaseFields(row, builder);
        return builder.operation(operation).role(role).build();
    }
}

