/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.internal.impl;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import java.util.Map;
import java.util.UUID;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.hawkular.accounts.api.CurrentUser;
import org.hawkular.accounts.api.NamedSetting;
import org.hawkular.accounts.api.UserService;
import org.hawkular.accounts.api.UserSettingsService;
import org.hawkular.accounts.api.internal.BoundStatements;
import org.hawkular.accounts.api.internal.NamedStatement;
import org.hawkular.accounts.api.internal.impl.BaseServiceImpl;
import org.hawkular.accounts.api.model.HawkularUser;
import org.hawkular.accounts.api.model.UserSettings;

@Stateless
@PermitAll
public class UserSettingsServiceImpl
extends BaseServiceImpl<UserSettings>
implements UserSettingsService {
    @Inject
    @CurrentUser
    HawkularUser user;
    @Inject
    UserService userService;
    @Inject
    @NamedStatement(value=BoundStatements.SETTINGS_GET_BY_ID)
    BoundStatement getById;
    @Inject
    @NamedStatement(value=BoundStatements.SETTINGS_GET_BY_USER)
    BoundStatement getByUser;
    @Inject
    @NamedStatement(value=BoundStatements.SETTINGS_UPDATE)
    BoundStatement updateStatement;
    @Inject
    @NamedStatement(value=BoundStatements.SETTINGS_CREATE)
    BoundStatement createStatement;

    @Override
    public UserSettings get(String id) {
        return this.getById(UUID.fromString(id));
    }

    @Override
    public UserSettings getById(UUID id) {
        return (UserSettings)this.getById(id, this.getById);
    }

    @Override
    public UserSettings getByUser() {
        return this.getByUser(this.user);
    }

    @Override
    public UserSettings getByUser(HawkularUser user) {
        return (UserSettings)this.getSingleRecord(this.getByUser.setUUID("persona", user.getIdAsUUID()));
    }

    @Override
    public UserSettings getOrCreateByUser() {
        return this.getOrCreateByUser(this.user);
    }

    @Override
    public UserSettings getOrCreateByUser(HawkularUser user) {
        UserSettings settings = this.getByUser(user);
        if (null == settings) {
            settings = new UserSettings(user);
            this.bindBasicParameters(settings, this.createStatement);
            this.createStatement.setUUID("persona", user.getIdAsUUID());
            this.session.execute((Statement)this.createStatement);
        }
        return settings;
    }

    @Override
    public String getSettingByKey(String key) {
        return this.getSettingByKey(this.user, key);
    }

    @Override
    public String getSettingByKey(String key, String defaultValue) {
        return this.getSettingByKey(this.user, key, defaultValue);
    }

    @Override
    public String getSettingByKey(HawkularUser user, String key) {
        UserSettings settings = this.getByUser(user);
        if (null == settings) {
            return null;
        }
        return settings.get(key);
    }

    @Override
    public String getSettingByKey(HawkularUser user, String key, String defaultValue) {
        String value = this.getSettingByKey(user, key);
        return value == null ? defaultValue : value;
    }

    @Override
    public UserSettings store(HawkularUser user, String key, String value) {
        UserSettings settings = this.getOrCreateByUser(user);
        settings.put(key, value);
        this.updateStatement.setMap("properties", settings.getProperties());
        this.update(settings, this.updateStatement);
        return settings;
    }

    @Override
    public UserSettings store(String key, String value) {
        return this.store(this.user, key, value);
    }

    @Override
    public UserSettings remove(HawkularUser user, String key) {
        UserSettings settings = this.getByUser(user);
        if (null == settings) {
            return null;
        }
        settings.remove(key);
        this.updateStatement.setMap("properties", settings.getProperties());
        this.update(settings, this.updateStatement);
        return settings;
    }

    @Override
    public UserSettings remove(String key) {
        return this.remove(this.user, key);
    }

    @Override
    @Produces
    @NamedSetting
    public String produceSettingByName(InjectionPoint injectionPoint) {
        NamedSetting namedSetting = (NamedSetting)injectionPoint.getAnnotated().getAnnotation(NamedSetting.class);
        String setting = namedSetting.value();
        return this.getSettingByKey(setting);
    }

    @Override
    UserSettings getFromRow(Row row) {
        HawkularUser user = this.userService.getById(row.getUUID("persona"));
        Map properties = row.getMap("properties", String.class, String.class);
        UserSettings.Builder builder = new UserSettings.Builder();
        this.mapBaseFields(row, builder);
        return builder.user(user).properties(properties).build();
    }
}

