/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.internal.impl;

import java.util.List;
import java.util.Set;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hawkular.accounts.api.NamedOperation;
import org.hawkular.accounts.api.OperationService;
import org.hawkular.accounts.api.PermissionService;
import org.hawkular.accounts.api.RoleService;
import org.hawkular.accounts.api.internal.adapter.HawkularAccounts;
import org.hawkular.accounts.api.model.Operation;
import org.hawkular.accounts.api.model.Operation_;
import org.hawkular.accounts.api.model.Permission;
import org.hawkular.accounts.api.model.Role;

@Stateless
@PermitAll
public class OperationServiceImpl
implements OperationService {
    @Inject
    @HawkularAccounts
    EntityManager em;
    @Inject
    PermissionService permissionService;
    @Inject
    RoleService roleService;

    @Override
    public Operation getByName(String name) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Operation.class);
        Root root = query.from(Operation.class);
        query.select((Selection)root);
        query.where((Expression)builder.equal((Expression)root.get(Operation_.name), (Object)name));
        List results = this.em.createQuery(query).getResultList();
        if (results.size() == 1) {
            Operation operation = (Operation)results.get(0);
            return operation;
        }
        if (results.size() > 1) {
            throw new IllegalStateException("More than one operation found for name " + name);
        }
        return null;
    }

    @Override
    @Produces
    @NamedOperation
    public Operation produceOperationByName(InjectionPoint injectionPoint) {
        NamedOperation namedOperation = (NamedOperation)injectionPoint.getAnnotated().getAnnotation(NamedOperation.class);
        String operationName = namedOperation.value();
        return this.getByName(operationName);
    }

    @Override
    public Setup setup(Operation operation) {
        return new Setup(operation);
    }

    @Override
    public Setup setup(String operationName) {
        Operation operation = this.getByName(operationName);
        if (null == operation) {
            operation = new Operation(operationName);
            this.em.persist((Object)operation);
        }
        return this.setup(operation);
    }

    public class Setup
    implements OperationService.Setup {
        private Operation operation;
        private Set<Role> roles;
        private boolean rolesHaveChanged = false;

        private Setup(Operation operation) {
            this.operation = operation;
            this.roles = OperationServiceImpl.this.permissionService.getPermittedRoles(operation);
        }

        @Override
        public OperationService.Setup add(Role role) {
            if (null == role) {
                throw new IllegalArgumentException("The given role is invalid (null).");
            }
            if (!this.roles.contains(role)) {
                Set<Role> implicitRoles = OperationServiceImpl.this.roleService.getImplicitPermittedRoles(role);
                this.rolesHaveChanged = true;
                this.roles.addAll(implicitRoles);
                this.roles.add(role);
            }
            return this;
        }

        @Override
        public OperationService.Setup add(String roleName) {
            return this.add(OperationServiceImpl.this.roleService.getByName(roleName));
        }

        @Override
        public OperationService.Setup add(Role role1, Role role2) {
            return this.add(role1).add(role2);
        }

        @Override
        public OperationService.Setup add(Role role1, Role role2, Role role3) {
            return this.add(role1).add(role2).add(role3);
        }

        @Override
        public OperationService.Setup add(Role ... roles) {
            for (Role role : roles) {
                this.add(role);
            }
            return this;
        }

        @Override
        public OperationService.Setup clear() {
            this.rolesHaveChanged = true;
            this.roles.clear();
            return this;
        }

        @Override
        public OperationService persist() {
            this.doPersist();
            return OperationServiceImpl.this;
        }

        @Override
        public Operation make() {
            this.doPersist();
            return this.operation;
        }

        private void doPersist() {
            if (this.rolesHaveChanged) {
                Set<Permission> permissions = OperationServiceImpl.this.permissionService.getPermissionsForOperation(this.operation);
                permissions.forEach(arg_0 -> ((EntityManager)OperationServiceImpl.this.em).remove(arg_0));
                this.roles.forEach(role -> OperationServiceImpl.this.em.persist((Object)new Permission(this.operation, (Role)role)));
            }
        }
    }
}

