/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.internal.impl;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.hawkular.accounts.api.NamedRole;
import org.hawkular.accounts.api.OrganizationMembershipService;
import org.hawkular.accounts.api.OrganizationService;
import org.hawkular.accounts.api.internal.adapter.HawkularAccounts;
import org.hawkular.accounts.api.model.Organization;
import org.hawkular.accounts.api.model.OrganizationMembership;
import org.hawkular.accounts.api.model.Persona;
import org.hawkular.accounts.api.model.Role;

@Stateless
@PermitAll
public class OrganizationServiceImpl
implements OrganizationService {
    @Inject
    @HawkularAccounts
    EntityManager em;
    @Inject
    OrganizationMembershipService membershipService;
    @Inject
    @NamedRole(value="SuperUser")
    Role superUser;

    @Override
    public List<Organization> getOrganizationsForPersona(Persona persona) {
        return this.getOrganizationsFromMemberships(this.membershipService.getMembershipsForPersona(persona));
    }

    @Override
    public List<Organization> getOrganizationsFromMemberships(List<OrganizationMembership> memberships) {
        return memberships.stream().map(OrganizationMembership::getOrganization).distinct().collect(Collectors.toList());
    }

    @Override
    public Organization createOrganization(String name, String description, Persona owner) {
        Organization organization = new Organization(owner);
        organization.setName(name);
        organization.setDescription(description);
        this.em.persist((Object)organization);
        this.em.persist((Object)new OrganizationMembership(organization, owner, this.superUser));
        return organization;
    }

    @Override
    public void deleteOrganization(Organization organization) {
        this.membershipService.getMembershipsForOrganization(organization).stream().forEach(arg_0 -> ((EntityManager)this.em).remove(arg_0));
        this.em.remove((Object)organization);
    }
}

