/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.internal.impl;

import java.util.List;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hawkular.accounts.api.InvitationService;
import org.hawkular.accounts.api.OrganizationMembershipService;
import org.hawkular.accounts.api.internal.adapter.HawkularAccounts;
import org.hawkular.accounts.api.model.HawkularUser;
import org.hawkular.accounts.api.model.Invitation;
import org.hawkular.accounts.api.model.Invitation_;
import org.hawkular.accounts.api.model.Organization;
import org.hawkular.accounts.api.model.OrganizationMembership;
import org.hawkular.accounts.api.model.Role;

@Stateless
@PermitAll
public class InvitationServiceImpl
implements InvitationService {
    @Inject
    @HawkularAccounts
    EntityManager em;
    @Inject
    OrganizationMembershipService membershipService;

    @Override
    public Invitation getByToken(String token) {
        if (null == token) {
            throw new IllegalArgumentException("The given Invitation Token is invalid (null).");
        }
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Invitation.class);
        Root root = query.from(Invitation.class);
        query.select((Selection)root);
        query.where((Expression)builder.equal((Expression)root.get(Invitation_.token), (Object)token));
        List results = this.em.createQuery(query).getResultList();
        if (results.size() == 1) {
            return (Invitation)results.get(0);
        }
        if (results.size() > 1) {
            throw new IllegalStateException("More than one invitation found for token " + token);
        }
        return null;
    }

    @Override
    public Invitation get(String id) {
        if (null == id) {
            throw new IllegalArgumentException("The given Invitation ID is invalid (null).");
        }
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Invitation.class);
        Root root = query.from(Invitation.class);
        query.select((Selection)root);
        query.where((Expression)builder.equal((Expression)root.get(Invitation_.id), (Object)id));
        List results = this.em.createQuery(query).getResultList();
        if (results.size() == 1) {
            return (Invitation)results.get(0);
        }
        if (results.size() > 1) {
            throw new IllegalStateException("More than one invitation found for ID " + id);
        }
        return null;
    }

    @Override
    public List<Invitation> getPendingInvitationsForOrganization(Organization organization) {
        if (null == organization) {
            throw new IllegalArgumentException("The given Organization is invalid (null).");
        }
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Invitation.class);
        Root root = query.from(Invitation.class);
        query.select((Selection)root);
        query.where(new Predicate[]{builder.equal((Expression)root.get(Invitation_.organization), (Object)organization), builder.isNull((Expression)root.get(Invitation_.acceptedAt))});
        return this.em.createQuery(query).getResultList();
    }

    @Override
    public List<Invitation> getInvitationsForOrganization(Organization organization) {
        if (null == organization) {
            throw new IllegalArgumentException("The given Organization is invalid (null).");
        }
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Invitation.class);
        Root root = query.from(Invitation.class);
        query.select((Selection)root);
        query.where((Expression)builder.equal((Expression)root.get(Invitation_.organization), (Object)organization));
        return this.em.createQuery(query).getResultList();
    }

    @Override
    public Invitation create(String email, HawkularUser invitedBy, Organization organization, Role role) {
        Invitation invitation = new Invitation(email, invitedBy, organization, role);
        this.em.persist((Object)invitation);
        return invitation;
    }

    @Override
    public Invitation accept(Invitation invitation, HawkularUser user) {
        OrganizationMembership membership = this.membershipService.create(invitation.getOrganization(), user, invitation.getRole());
        invitation.setAccepted();
        invitation.setAcceptedBy(user);
        this.em.persist((Object)invitation);
        this.em.persist((Object)membership);
        return invitation;
    }

    @Override
    public void remove(Invitation invitation) {
        if (null != invitation) {
            this.em.remove((Object)invitation);
        }
    }
}

