/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.accounts.api.internal.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.servlet.http.HttpServletRequest;
import org.hawkular.accounts.api.OrganizationMembershipService;
import org.hawkular.accounts.api.OrganizationService;
import org.hawkular.accounts.api.PersonaService;
import org.hawkular.accounts.api.UserService;
import org.hawkular.accounts.api.internal.adapter.HawkularAccounts;
import org.hawkular.accounts.api.model.HawkularUser;
import org.hawkular.accounts.api.model.Organization;
import org.hawkular.accounts.api.model.OrganizationMembership;
import org.hawkular.accounts.api.model.Persona;
import org.hawkular.accounts.api.model.PersonaResourceRole;
import org.hawkular.accounts.api.model.PersonaResourceRole_;
import org.hawkular.accounts.api.model.Persona_;
import org.hawkular.accounts.api.model.Resource;
import org.hawkular.accounts.api.model.Role;

@Stateless
@PermitAll
public class PersonaServiceImpl
implements PersonaService {
    @Inject
    @HawkularAccounts
    EntityManager em;
    @Inject
    OrganizationMembershipService membershipService;
    @Inject
    OrganizationService organizationService;
    @Inject
    UserService userService;
    @Inject
    private HttpServletRequest httpRequest;

    @Override
    public Persona get(String id) {
        if (null == id) {
            throw new IllegalArgumentException("The provided Persona ID is invalid (null).");
        }
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Persona.class);
        Root root = query.from(Persona.class);
        query.select((Selection)root);
        query.where((Expression)builder.equal((Expression)root.get(Persona_.id), (Object)id));
        List results = this.em.createQuery(query).getResultList();
        if (results.size() == 1) {
            return (Persona)results.get(0);
        }
        if (results.size() > 1) {
            throw new IllegalStateException("More than one owner found for ID " + id);
        }
        return null;
    }

    @Override
    public Set<Role> getEffectiveRolesForResource(Persona persona, Resource resource) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(PersonaResourceRole.class);
        Root root = query.from(PersonaResourceRole.class);
        query.select((Selection)root);
        query.where(new Predicate[]{builder.equal((Expression)root.get(PersonaResourceRole_.persona), (Object)persona), builder.equal((Expression)root.get(PersonaResourceRole_.resource), (Object)resource)});
        List results = this.em.createQuery(query).getResultList();
        if (results.size() == 0) {
            List<OrganizationMembership> memberships = this.membershipService.getMembershipsForPersona(persona);
            List<Organization> organizations = this.organizationService.getOrganizationsFromMemberships(memberships);
            HashSet<Role> roles = new HashSet<Role>();
            for (Organization organization : organizations) {
                Set<Role> organizationRolesForResource = this.getEffectiveRolesForResource(organization, resource);
                Set effectiveRoles = memberships.stream().filter(m -> m.getOrganization().equals(organization)).map(OrganizationMembership::getRole).filter(organizationRolesForResource::contains).collect(Collectors.toSet());
                roles.addAll(effectiveRoles);
            }
            return roles;
        }
        HashSet<Role> roles = new HashSet<Role>(results.size());
        roles.addAll(results.stream().map(PersonaResourceRole::getRole).collect(Collectors.toSet()));
        return roles;
    }

    @Override
    @Produces
    public Persona getCurrent() {
        String personaId = this.httpRequest.getHeader("Hawkular-Persona");
        if (personaId != null && !personaId.isEmpty()) {
            Persona persona = this.get(personaId);
            if (this.isAllowedToImpersonate(this.userService.getCurrent(), persona)) {
                return persona;
            }
            throw new RuntimeException("User is not allowed to impersonate this persona.");
        }
        return this.userService.getCurrent();
    }

    @Override
    public boolean isAllowedToImpersonate(HawkularUser actual, Persona toImpersonate) {
        return true;
    }
}

