/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.shared.impl.cldr;
// DO NOT EDIT - GENERATED FROM CLDR AND ICU DATA

/**
 * Implementation of DateTimeFormatInfo for the "pl" locale.
 */
public class DateTimeFormatInfoImpl_pl extends DateTimeFormatInfoImpl {

  @Override
  public String dateFormatFull() {
    return "EEEE, d MMMM y";
  }

  @Override
  public String dateFormatLong() {
    return "d MMMM y";
  }

  @Override
  public String dateFormatMedium() {
    return "d MMM y";
  }

  @Override
  public String dateFormatShort() {
    return "dd.MM.y";
  }

  @Override
  public String dateTimeMedium(String timePattern, String datePattern) {
    return datePattern + ", " + timePattern;
  }

  @Override
  public String dateTimeShort(String timePattern, String datePattern) {
    return datePattern + ", " + timePattern;
  }

  @Override
  public String[] erasFull() {
    return new String[] {
        "przed naszą erą",
        "naszej ery"
    };
  }

  @Override
  public String[] erasShort() {
    return new String[] {
        "p.n.e.",
        "n.e."
    };
  }

  @Override
  public String formatMonthAbbrevDay() {
    return "d MMM";
  }

  @Override
  public String formatMonthFullDay() {
    return "d MMMM";
  }

  @Override
  public String formatMonthFullWeekdayDay() {
    return "EEEE, d MMMM";
  }

  @Override
  public String formatMonthNumDay() {
    return "d.MM";
  }

  @Override
  public String formatYearMonthAbbrev() {
    return "LLL y";
  }

  @Override
  public String formatYearMonthAbbrevDay() {
    return "d MMM y";
  }

  @Override
  public String formatYearMonthFull() {
    return "LLLL y";
  }

  @Override
  public String formatYearMonthFullDay() {
    return "d MMMM y";
  }

  @Override
  public String formatYearMonthNum() {
    return "MM.y";
  }

  @Override
  public String formatYearMonthNumDay() {
    return "d.MM.y";
  }

  @Override
  public String formatYearMonthWeekdayDay() {
    return "EEE, d MMM y";
  }

  @Override
  public String formatYearQuarterFull() {
    return "QQQQ y";
  }

  @Override
  public String formatYearQuarterShort() {
    return "Q y";
  }

  @Override
  public String[] monthsFull() {
    return new String[] {
        "stycznia",
        "lutego",
        "marca",
        "kwietnia",
        "maja",
        "czerwca",
        "lipca",
        "sierpnia",
        "września",
        "października",
        "listopada",
        "grudnia"
    };
  }

  @Override
  public String[] monthsFullStandalone() {
    return new String[] {
        "styczeń",
        "luty",
        "marzec",
        "kwiecień",
        "maj",
        "czerwiec",
        "lipiec",
        "sierpień",
        "wrzesień",
        "październik",
        "listopad",
        "grudzień"
    };
  }

  @Override
  public String[] monthsNarrow() {
    return new String[] {
        "s",
        "l",
        "m",
        "k",
        "m",
        "c",
        "l",
        "s",
        "w",
        "p",
        "l",
        "g"
    };
  }

  @Override
  public String[] monthsNarrowStandalone() {
    return new String[] {
        "S",
        "L",
        "M",
        "K",
        "M",
        "C",
        "L",
        "S",
        "W",
        "P",
        "L",
        "G"
    };
  }

  @Override
  public String[] monthsShort() {
    return new String[] {
        "sty",
        "lut",
        "mar",
        "kwi",
        "maj",
        "cze",
        "lip",
        "sie",
        "wrz",
        "paź",
        "lis",
        "gru"
    };
  }

  @Override
  public String[] quartersFull() {
    return new String[] {
        "I kwartał",
        "II kwartał",
        "III kwartał",
        "IV kwartał"
    };
  }

  @Override
  public String[] quartersShort() {
    return new String[] {
        "I kw.",
        "II kw.",
        "III kw.",
        "IV kw."
    };
  }

  @Override
  public String[] weekdaysFull() {
    return new String[] {
        "niedziela",
        "poniedziałek",
        "wtorek",
        "środa",
        "czwartek",
        "piątek",
        "sobota"
    };
  }

  @Override
  public String[] weekdaysNarrow() {
    return new String[] {
        "n",
        "p",
        "w",
        "ś",
        "c",
        "p",
        "s"
    };
  }

  @Override
  public String[] weekdaysNarrowStandalone() {
    return new String[] {
        "N",
        "P",
        "W",
        "Ś",
        "C",
        "P",
        "S"
    };
  }

  @Override
  public String[] weekdaysShort() {
    return new String[] {
        "niedz.",
        "pon.",
        "wt.",
        "śr.",
        "czw.",
        "pt.",
        "sob."
    };
  }
}
