/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "nb" locale.
 */
public class LocalizedNamesImpl_nb extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "NO",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "AL",
        "DZ",
        "AS",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "AR",
        "AM",
        "AW",
        "AC",
        "AZ",
        "AU",
        "BS",
        "BH",
        "BD",
        "BB",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BT",
        "BO",
        "BA",
        "BW",
        "BV",
        "BR",
        "BN",
        "BG",
        "BF",
        "BI",
        "CA",
        "KY",
        "EA",
        "CL",
        "CX",
        "CP",
        "CO",
        "CK",
        "CR",
        "CU",
        "CW",
        "DK",
        "VI",
        "VG",
        "AE",
        "TF",
        "DO",
        "CF",
        "IO",
        "PS",
        "DG",
        "DJ",
        "DM",
        "EC",
        "EG",
        "GQ",
        "CI",
        "SV",
        "ER",
        "EE",
        "ET",
        "EU",
        "EZ",
        "FK",
        "FJ",
        "PH",
        "FI",
        "UN",
        "FR",
        "GF",
        "PF",
        "FO",
        "GA",
        "GM",
        "GE",
        "GH",
        "GI",
        "GD",
        "GL",
        "GP",
        "GU",
        "GT",
        "GG",
        "GN",
        "GW",
        "GY",
        "HT",
        "HM",
        "GR",
        "HN",
        "HK",
        "BY",
        "IN",
        "ID",
        "IQ",
        "IR",
        "IE",
        "IS",
        "IL",
        "IT",
        "JM",
        "JP",
        "YE",
        "JE",
        "JO",
        "KH",
        "CM",
        "IC",
        "CV",
        "BQ",
        "KZ",
        "KE",
        "CN",
        "KG",
        "KI",
        "CC",
        "KM",
        "CG",
        "CD",
        "XK",
        "HR",
        "KW",
        "CY",
        "LA",
        "LV",
        "LS",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MO",
        "MG",
        "MK",
        "MW",
        "MY",
        "MV",
        "ML",
        "MT",
        "IM",
        "MA",
        "MH",
        "MQ",
        "MR",
        "MU",
        "YT",
        "MX",
        "FM",
        "MD",
        "MC",
        "MN",
        "ME",
        "MS",
        "MZ",
        "MM",
        "NA",
        "NR",
        "NL",
        "NP",
        "NZ",
        "NI",
        "NE",
        "NG",
        "NU",
        "KP",
        "MP",
        "NF",
        "NO",
        "NC",
        "OM",
        "PK",
        "PW",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PL",
        "PT",
        "PR",
        "QA",
        "RE",
        "RO",
        "RU",
        "RW",
        "BL",
        "KN",
        "MF",
        "PM",
        "SB",
        "WS",
        "SM",
        "ST",
        "SA",
        "SN",
        "RS",
        "SC",
        "SL",
        "SG",
        "SX",
        "SK",
        "SI",
        "SO",
        "ES",
        "LK",
        "SH",
        "LC",
        "VC",
        "GB",
        "SD",
        "SR",
        "SJ",
        "CH",
        "SE",
        "SZ",
        "SY",
        "ZA",
        "GS",
        "KR",
        "SS",
        "TJ",
        "TW",
        "TZ",
        "TH",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TD",
        "CZ",
        "TN",
        "TM",
        "TC",
        "TV",
        "TR",
        "DE",
        "UG",
        "UA",
        "HU",
        "UY",
        "US",
        "UM",
        "UZ",
        "VU",
        "VA",
        "VE",
        "EH",
        "VN",
        "WF",
        "XA",
        "XB",
        "QO",
        "ZM",
        "ZW",
        "AT",
        "TL",
        "AX",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "verden");
    namesMap.put("002", "Afrika");
    namesMap.put("003", "Nord-Amerika");
    namesMap.put("005", "Sør-Amerika");
    namesMap.put("009", "Oseania");
    namesMap.put("011", "Vest-Afrika");
    namesMap.put("013", "Mellom-Amerika");
    namesMap.put("014", "Øst-Afrika");
    namesMap.put("015", "Nord-Afrika");
    namesMap.put("017", "Sentral-Afrika");
    namesMap.put("018", "Sørlige Afrika");
    namesMap.put("019", "Amerika");
    namesMap.put("021", "Nordlige Amerika");
    namesMap.put("029", "Karibia");
    namesMap.put("030", "Øst-Asia");
    namesMap.put("034", "Sør-Asia");
    namesMap.put("035", "Sørøst-Asia");
    namesMap.put("039", "Sør-Europa");
    namesMap.put("057", "Mikronesia");
    namesMap.put("143", "Sentral-Asia");
    namesMap.put("145", "Vest-Asia");
    namesMap.put("150", "Europa");
    namesMap.put("151", "Øst-Europa");
    namesMap.put("154", "Nord-Europa");
    namesMap.put("155", "Vest-Europa");
    namesMap.put("202", "Afrika sør for Sahara");
    namesMap.put("419", "Latin-Amerika");
    namesMap.put("AC", "Ascension");
    namesMap.put("AE", "De forente arabiske emirater");
    namesMap.put("AG", "Antigua og Barbuda");
    namesMap.put("AQ", "Antarktis");
    namesMap.put("AS", "Amerikansk Samoa");
    namesMap.put("AT", "Østerrike");
    namesMap.put("AX", "Åland");
    namesMap.put("AZ", "Aserbajdsjan");
    namesMap.put("BA", "Bosnia-Hercegovina");
    namesMap.put("BE", "Belgia");
    namesMap.put("BL", "Saint-Barthélemy");
    namesMap.put("BQ", "Karibisk Nederland");
    namesMap.put("BR", "Brasil");
    namesMap.put("BV", "Bouvetøya");
    namesMap.put("BY", "Hviterussland");
    namesMap.put("CC", "Kokosøyene");
    namesMap.put("CD", "Kongo-Kinshasa");
    namesMap.put("CF", "Den sentralafrikanske republikk");
    namesMap.put("CG", "Kongo-Brazzaville");
    namesMap.put("CH", "Sveits");
    namesMap.put("CI", "Elfenbenskysten");
    namesMap.put("CK", "Cookøyene");
    namesMap.put("CM", "Kamerun");
    namesMap.put("CN", "Kina");
    namesMap.put("CP", "Clippertonøya");
    namesMap.put("CV", "Kapp Verde");
    namesMap.put("CX", "Christmasøya");
    namesMap.put("CY", "Kypros");
    namesMap.put("CZ", "Tsjekkia");
    namesMap.put("DE", "Tyskland");
    namesMap.put("DK", "Danmark");
    namesMap.put("DO", "Den dominikanske republikk");
    namesMap.put("DZ", "Algerie");
    namesMap.put("EA", "Ceuta og Melilla");
    namesMap.put("EE", "Estland");
    namesMap.put("EH", "Vest-Sahara");
    namesMap.put("ES", "Spania");
    namesMap.put("ET", "Etiopia");
    namesMap.put("EZ", "eurosonen");
    namesMap.put("FK", "Falklandsøyene");
    namesMap.put("FM", "Mikronesiaføderasjonen");
    namesMap.put("FO", "Færøyene");
    namesMap.put("FR", "Frankrike");
    namesMap.put("GB", "Storbritannia");
    namesMap.put("GF", "Fransk Guyana");
    namesMap.put("GL", "Grønland");
    namesMap.put("GQ", "Ekvatorial-Guinea");
    namesMap.put("GR", "Hellas");
    namesMap.put("GS", "Sør-Georgia og Sør-Sandwichøyene");
    namesMap.put("HK", "Hongkong S.A.R. Kina");
    namesMap.put("HM", "Heard- og McDonaldøyene");
    namesMap.put("HR", "Kroatia");
    namesMap.put("HU", "Ungarn");
    namesMap.put("IC", "Kanariøyene");
    namesMap.put("IE", "Irland");
    namesMap.put("IM", "Man");
    namesMap.put("IO", "Det britiske territoriet i Indiahavet");
    namesMap.put("IQ", "Irak");
    namesMap.put("IS", "Island");
    namesMap.put("IT", "Italia");
    namesMap.put("KG", "Kirgisistan");
    namesMap.put("KH", "Kambodsja");
    namesMap.put("KM", "Komorene");
    namesMap.put("KN", "Saint Kitts og Nevis");
    namesMap.put("KP", "Nord-Korea");
    namesMap.put("KR", "Sør-Korea");
    namesMap.put("KY", "Caymanøyene");
    namesMap.put("KZ", "Kasakhstan");
    namesMap.put("LB", "Libanon");
    namesMap.put("LT", "Litauen");
    namesMap.put("LU", "Luxemburg");
    namesMap.put("MA", "Marokko");
    namesMap.put("MF", "Saint-Martin");
    namesMap.put("MG", "Madagaskar");
    namesMap.put("MH", "Marshalløyene");
    namesMap.put("MK", "Makedonia");
    namesMap.put("MO", "Macao S.A.R. Kina");
    namesMap.put("MP", "Nord-Marianene");
    namesMap.put("MV", "Maldivene");
    namesMap.put("MZ", "Mosambik");
    namesMap.put("NC", "Ny-Caledonia");
    namesMap.put("NF", "Norfolkøya");
    namesMap.put("NL", "Nederland");
    namesMap.put("NO", "Norge");
    namesMap.put("PF", "Fransk Polynesia");
    namesMap.put("PG", "Papua Ny-Guinea");
    namesMap.put("PH", "Filippinene");
    namesMap.put("PL", "Polen");
    namesMap.put("PM", "Saint-Pierre-et-Miquelon");
    namesMap.put("PN", "Pitcairnøyene");
    namesMap.put("PS", "Det palestinske området");
    namesMap.put("QO", "Ytre Oseania");
    namesMap.put("RU", "Russland");
    namesMap.put("SA", "Saudi-Arabia");
    namesMap.put("SB", "Salomonøyene");
    namesMap.put("SC", "Seychellene");
    namesMap.put("SE", "Sverige");
    namesMap.put("SJ", "Svalbard og Jan Mayen");
    namesMap.put("SR", "Surinam");
    namesMap.put("SS", "Sør-Sudan");
    namesMap.put("ST", "São Tomé og Príncipe");
    namesMap.put("TC", "Turks- og Caicosøyene");
    namesMap.put("TD", "Tsjad");
    namesMap.put("TF", "De franske sørterritorier");
    namesMap.put("TJ", "Tadsjikistan");
    namesMap.put("TL", "Øst-Timor");
    namesMap.put("TR", "Tyrkia");
    namesMap.put("TT", "Trinidad og Tobago");
    namesMap.put("UA", "Ukraina");
    namesMap.put("UM", "USAs ytre øyer");
    namesMap.put("UN", "FN");
    namesMap.put("US", "USA");
    namesMap.put("UZ", "Usbekistan");
    namesMap.put("VA", "Vatikanstaten");
    namesMap.put("VC", "St. Vincent og Grenadinene");
    namesMap.put("VG", "De britiske jomfruøyene");
    namesMap.put("VI", "De amerikanske jomfruøyene");
    namesMap.put("WF", "Wallis og Futuna");
    namesMap.put("YE", "Jemen");
    namesMap.put("ZA", "Sør-Afrika");
    namesMap.put("ZZ", "ukjent område");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "verden",
        "002": "Afrika",
        "003": "Nord-Amerika",
        "005": "Sør-Amerika",
        "009": "Oseania",
        "011": "Vest-Afrika",
        "013": "Mellom-Amerika",
        "014": "Øst-Afrika",
        "015": "Nord-Afrika",
        "017": "Sentral-Afrika",
        "018": "Sørlige Afrika",
        "019": "Amerika",
        "021": "Nordlige Amerika",
        "029": "Karibia",
        "030": "Øst-Asia",
        "034": "Sør-Asia",
        "035": "Sørøst-Asia",
        "039": "Sør-Europa",
        "057": "Mikronesia",
        "143": "Sentral-Asia",
        "145": "Vest-Asia",
        "150": "Europa",
        "151": "Øst-Europa",
        "154": "Nord-Europa",
        "155": "Vest-Europa",
        "202": "Afrika sør for Sahara",
        "419": "Latin-Amerika",
        "AC": "Ascension",
        "AE": "De forente arabiske emirater",
        "AG": "Antigua og Barbuda",
        "AQ": "Antarktis",
        "AS": "Amerikansk Samoa",
        "AT": "Østerrike",
        "AX": "Åland",
        "AZ": "Aserbajdsjan",
        "BA": "Bosnia-Hercegovina",
        "BE": "Belgia",
        "BL": "Saint-Barthélemy",
        "BQ": "Karibisk Nederland",
        "BR": "Brasil",
        "BV": "Bouvetøya",
        "BY": "Hviterussland",
        "CC": "Kokosøyene",
        "CD": "Kongo-Kinshasa",
        "CF": "Den sentralafrikanske republikk",
        "CG": "Kongo-Brazzaville",
        "CH": "Sveits",
        "CI": "Elfenbenskysten",
        "CK": "Cookøyene",
        "CM": "Kamerun",
        "CN": "Kina",
        "CP": "Clippertonøya",
        "CV": "Kapp Verde",
        "CX": "Christmasøya",
        "CY": "Kypros",
        "CZ": "Tsjekkia",
        "DE": "Tyskland",
        "DK": "Danmark",
        "DO": "Den dominikanske republikk",
        "DZ": "Algerie",
        "EA": "Ceuta og Melilla",
        "EE": "Estland",
        "EH": "Vest-Sahara",
        "ES": "Spania",
        "ET": "Etiopia",
        "EZ": "eurosonen",
        "FK": "Falklandsøyene",
        "FM": "Mikronesiaføderasjonen",
        "FO": "Færøyene",
        "FR": "Frankrike",
        "GB": "Storbritannia",
        "GF": "Fransk Guyana",
        "GL": "Grønland",
        "GQ": "Ekvatorial-Guinea",
        "GR": "Hellas",
        "GS": "Sør-Georgia og Sør-Sandwichøyene",
        "HK": "Hongkong S.A.R. Kina",
        "HM": "Heard- og McDonaldøyene",
        "HR": "Kroatia",
        "HU": "Ungarn",
        "IC": "Kanariøyene",
        "IE": "Irland",
        "IM": "Man",
        "IO": "Det britiske territoriet i Indiahavet",
        "IQ": "Irak",
        "IS": "Island",
        "IT": "Italia",
        "KG": "Kirgisistan",
        "KH": "Kambodsja",
        "KM": "Komorene",
        "KN": "Saint Kitts og Nevis",
        "KP": "Nord-Korea",
        "KR": "Sør-Korea",
        "KY": "Caymanøyene",
        "KZ": "Kasakhstan",
        "LB": "Libanon",
        "LT": "Litauen",
        "LU": "Luxemburg",
        "MA": "Marokko",
        "MF": "Saint-Martin",
        "MG": "Madagaskar",
        "MH": "Marshalløyene",
        "MK": "Makedonia",
        "MO": "Macao S.A.R. Kina",
        "MP": "Nord-Marianene",
        "MV": "Maldivene",
        "MZ": "Mosambik",
        "NC": "Ny-Caledonia",
        "NF": "Norfolkøya",
        "NL": "Nederland",
        "NO": "Norge",
        "PF": "Fransk Polynesia",
        "PG": "Papua Ny-Guinea",
        "PH": "Filippinene",
        "PL": "Polen",
        "PM": "Saint-Pierre-et-Miquelon",
        "PN": "Pitcairnøyene",
        "PS": "Det palestinske området",
        "QO": "Ytre Oseania",
        "RU": "Russland",
        "SA": "Saudi-Arabia",
        "SB": "Salomonøyene",
        "SC": "Seychellene",
        "SE": "Sverige",
        "SJ": "Svalbard og Jan Mayen",
        "SR": "Surinam",
        "SS": "Sør-Sudan",
        "ST": "São Tomé og Príncipe",
        "TC": "Turks- og Caicosøyene",
        "TD": "Tsjad",
        "TF": "De franske sørterritorier",
        "TJ": "Tadsjikistan",
        "TL": "Øst-Timor",
        "TR": "Tyrkia",
        "TT": "Trinidad og Tobago",
        "UA": "Ukraina",
        "UM": "USAs ytre øyer",
        "UN": "FN",
        "US": "USA",
        "UZ": "Usbekistan",
        "VA": "Vatikanstaten",
        "VC": "St. Vincent og Grenadinene",
        "VG": "De britiske jomfruøyene",
        "VI": "De amerikanske jomfruøyene",
        "WF": "Wallis og Futuna",
        "YE": "Jemen",
        "ZA": "Sør-Afrika",
        "ZZ": "ukjent område"
    };
  }-*/;
}
