/*
 * Decompiled with CFR 0.152.
 */
package org.gwizard.web;

import com.google.common.base.Preconditions;
import com.google.inject.servlet.GuiceFilter;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.gwizard.web.EventListenerScanner;
import org.gwizard.web.HandlerScanner;
import org.gwizard.web.WebConfig;

@Singleton
public class WebServer {
    private final WebConfig webConfig;
    private final EventListenerScanner eventListenerScanner;
    private final HandlerScanner handlerScanner;
    private Server server;

    @Inject
    public WebServer(WebConfig webConfig, EventListenerScanner eventListenerScanner, HandlerScanner handlerScanner) {
        this.webConfig = webConfig;
        this.eventListenerScanner = eventListenerScanner;
        this.handlerScanner = handlerScanner;
    }

    public void start() throws Exception {
        Preconditions.checkState((this.server == null ? 1 : 0) != 0, (Object)"Server already started");
        this.server = this.createServer(this.webConfig);
        ServletContextHandler sch = this.createRootServletContextHandler();
        sch.addFilter(GuiceFilter.class, "/*", null);
        sch.addServlet(DefaultServlet.class, "/");
        this.eventListenerScanner.accept(arg_0 -> ((ServletContextHandler)sch).addEventListener(arg_0));
        HandlerCollection handlers = new HandlerCollection();
        handlers.addHandler((Handler)sch);
        this.handlerScanner.accept(arg_0 -> ((HandlerCollection)handlers).addHandler(arg_0));
        this.server.setHandler((Handler)handlers);
        this.server.start();
    }

    protected ServletContextHandler createRootServletContextHandler() {
        return new ServletContextHandler(null, "/");
    }

    protected Server createServer(WebConfig webConfig) {
        return new Server(webConfig.getPort());
    }

    public void stop() throws Exception {
        Preconditions.checkState((this.server != null ? 1 : 0) != 0, (Object)"Server not started");
        this.server.stop();
    }
}

