/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.config;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import javax.naming.InitialContext;
import org.guvnor.structure.backend.config.ConfigGroupMarshaller;
import org.guvnor.structure.backend.config.OrgUnit;
import org.guvnor.structure.backend.config.Repository;
import org.guvnor.structure.backend.config.watch.AsyncConfigWatchService;
import org.guvnor.structure.backend.config.watch.AsyncWatchServiceCallback;
import org.guvnor.structure.backend.config.watch.ConfigServiceWatchServiceExecutor;
import org.guvnor.structure.backend.config.watch.ConfigServiceWatchServiceExecutorImpl;
import org.guvnor.structure.config.SystemRepositoryChangedEvent;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationService;
import org.jboss.errai.security.shared.api.identity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.commons.async.DescriptiveRunnable;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.WatchContext;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.StandardWatchEventKind;
import org.uberfire.java.nio.file.WatchEvent;
import org.uberfire.java.nio.file.WatchKey;
import org.uberfire.java.nio.file.WatchService;

@ApplicationScoped
public class ConfigurationServiceImpl
implements ConfigurationService,
AsyncWatchServiceCallback {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationServiceImpl.class);
    private static final String MONITOR_DISABLED = "org.uberfire.sys.repo.monitor.disabled";
    private static final String INVALID_FILENAME_CHARS = "[\\,/,:,*,?,\",<,>,|]";
    @Inject
    @Named(value="system")
    private org.guvnor.structure.repositories.Repository systemRepository;
    @Inject
    private ConfigGroupMarshaller marshaller;
    @Inject
    private User identity;
    private final Map<ConfigType, List<ConfigGroup>> configuration = new ConcurrentHashMap<ConfigType, List<ConfigGroup>>();
    private AtomicLong localLastModifiedValue = new AtomicLong(-1L);
    @Inject
    @Named(value="configIO")
    private IOService ioService;
    @Inject
    @Repository
    private Event<SystemRepositoryChangedEvent> repoChangedEvent;
    @Inject
    @OrgUnit
    private Event<SystemRepositoryChangedEvent> orgUnitChangedEvent;
    @Inject
    private Event<SystemRepositoryChangedEvent> changedEvent;
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final Set<Future<?>> jobs = new CopyOnWriteArraySet();
    private ConfigServiceWatchServiceExecutor executor = null;
    private CheckConfigurationUpdates configUpdates = null;
    private WatchService watchService = null;
    @Inject
    @Named(value="systemFS")
    private FileSystem fs;

    @PostConstruct
    public void setup() {
        Path defaultRoot = null;
        for (Path path : this.fs.getRootDirectories()) {
            if (!path.toUri().toString().contains("/master@")) continue;
            defaultRoot = path;
            break;
        }
        if (defaultRoot == null) {
            throw new RuntimeException("Could not resolve 'systemFS' main root directory.");
        }
        this.systemRepository.setRoot(Paths.convert(defaultRoot));
        if (System.getProperty(MONITOR_DISABLED) == null) {
            this.watchService = this.fs.newWatchService();
            this.configUpdates = new CheckConfigurationUpdates(this.watchService);
            final ConfigServiceWatchServiceExecutor configServiceWatchServiceExecutor = this.getWatchServiceExecutor();
            this.jobs.add(this.executorService.submit((Runnable)new DescriptiveRunnable(){

                public String getDescription() {
                    return ConfigurationServiceImpl.this.configUpdates.getDescription();
                }

                public void run() {
                    ConfigurationServiceImpl.this.configUpdates.execute(configServiceWatchServiceExecutor);
                }
            }));
        }
    }

    @PreDestroy
    public void shutdown() {
        if (this.configUpdates != null) {
            this.configUpdates.deactivate();
        }
        if (this.watchService != null) {
            this.watchService.close();
        }
        for (Future<?> job : this.jobs) {
            if (job.isCancelled() || job.isDone()) continue;
            job.cancel(true);
        }
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
                if (!this.executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                    System.err.println("Pool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            this.executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public void startBatch() {
        this.ioService.startBatch(this.ioService.get(this.systemRepository.getUri(), new String[0]).getFileSystem());
    }

    public void endBatch() {
        this.ioService.endBatch();
    }

    public List<ConfigGroup> getConfiguration(final ConfigType type) {
        if (this.configuration.containsKey(type)) {
            return this.configuration.get(type);
        }
        ArrayList<ConfigGroup> configGroups = new ArrayList<ConfigGroup>();
        DirectoryStream foundConfigs = this.ioService.newDirectoryStream(this.ioService.get(this.systemRepository.getUri(), new String[0]), (DirectoryStream.Filter)new DirectoryStream.Filter<Path>(){

            public boolean accept(Path entry) throws IOException {
                return !Files.isDirectory((Path)entry, (LinkOption[])new LinkOption[0]) && !entry.getFileName().toString().startsWith(".") && entry.getFileName().toString().endsWith(type.getExt());
            }
        });
        Iterator it = foundConfigs.iterator();
        if (it.hasNext()) {
            while (it.hasNext()) {
                String content = this.ioService.readAllString((Path)it.next());
                ConfigGroup configGroup = this.marshaller.unmarshall(content);
                configGroups.add(configGroup);
            }
            this.configuration.put(type, configGroups);
        }
        return configGroups;
    }

    public boolean addConfiguration(ConfigGroup configGroup) {
        String filename = configGroup.getName().replaceAll(INVALID_FILENAME_CHARS, "_");
        Path filePath = this.ioService.get(this.systemRepository.getUri(), new String[0]).resolve(filename + configGroup.getType().getExt());
        if (this.ioService.exists(filePath)) {
            return true;
        }
        CommentedOption commentedOption = new CommentedOption(this.getIdentityName(), "Created config " + filePath.getFileName());
        try {
            this.ioService.startBatch(filePath.getFileSystem());
            this.ioService.write(filePath, this.marshaller.marshall(configGroup), new OpenOption[]{commentedOption});
            this.updateLastModified();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.ioService.endBatch();
        }
        this.configuration.remove(configGroup.getType());
        return true;
    }

    public boolean updateConfiguration(ConfigGroup configGroup) {
        String filename = configGroup.getName().replaceAll(INVALID_FILENAME_CHARS, "_");
        Path filePath = this.ioService.get(this.systemRepository.getUri(), new String[0]).resolve(filename + configGroup.getType().getExt());
        CommentedOption commentedOption = new CommentedOption(this.getIdentityName(), "Updated config " + filePath.getFileName());
        try {
            this.ioService.startBatch(filePath.getFileSystem());
            this.ioService.write(filePath, this.marshaller.marshall(configGroup), new OpenOption[]{commentedOption});
            this.updateLastModified();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.ioService.endBatch();
        }
        this.configuration.remove(configGroup.getType());
        return true;
    }

    public boolean removeConfiguration(ConfigGroup configGroup) {
        boolean result;
        this.configuration.remove(configGroup.getType());
        String filename = configGroup.getName().replaceAll(INVALID_FILENAME_CHARS, "_");
        Path filePath = this.ioService.get(this.systemRepository.getUri(), new String[0]).resolve(filename + configGroup.getType().getExt());
        if (!this.ioService.exists(filePath)) {
            return true;
        }
        try {
            this.ioService.startBatch(filePath.getFileSystem());
            result = this.ioService.deleteIfExists(filePath, new DeleteOption[0]);
            if (result) {
                this.updateLastModified();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.ioService.endBatch();
        }
        return result;
    }

    protected String getIdentityName() {
        try {
            return this.identity.getIdentifier();
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    protected long getLastModified() {
        Path lastModifiedPath = this.ioService.get(this.systemRepository.getUri(), new String[0]).resolve(".lastmodified");
        return this.ioService.getLastModifiedTime(lastModifiedPath).toMillis();
    }

    protected void updateLastModified() {
        Path lastModifiedPath = this.ioService.get(this.systemRepository.getUri(), new String[0]).resolve(".lastmodified");
        CommentedOption commentedOption = new CommentedOption("system", "system repo updated");
        this.ioService.write(lastModifiedPath, new Date().toString().getBytes(), new OpenOption[]{commentedOption});
        this.localLastModifiedValue.set(this.getLastModified());
    }

    @Override
    public void callback(long value) {
        this.localLastModifiedValue.set(value);
        this.configuration.clear();
    }

    protected ConfigServiceWatchServiceExecutor getWatchServiceExecutor() {
        if (this.executor == null) {
            ConfigServiceWatchServiceExecutor _executor = null;
            try {
                _executor = (ConfigServiceWatchServiceExecutor)InitialContext.doLookup("java:module/ConfigServiceWatchServiceExecutorImpl");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (_executor == null) {
                _executor = new ConfigServiceWatchServiceExecutorImpl();
                ((ConfigServiceWatchServiceExecutorImpl)_executor).setConfig(this.systemRepository, this.ioService, this.repoChangedEvent, this.orgUnitChangedEvent, this.changedEvent);
            }
            this.executor = _executor;
        }
        return this.executor;
    }

    private class CheckConfigurationUpdates
    implements AsyncConfigWatchService {
        private final WatchService ws;
        private boolean active = true;

        public CheckConfigurationUpdates(WatchService watchService) {
            this.ws = watchService;
        }

        public void deactivate() {
            this.active = false;
        }

        @Override
        public void execute(ConfigServiceWatchServiceExecutor wsExecutor) {
            while (this.active) {
                try {
                    boolean valid;
                    WatchKey wk;
                    try {
                        wk = this.ws.take();
                    }
                    catch (Exception ex) {
                        break;
                    }
                    List events = wk.pollEvents();
                    boolean markerFileModified = false;
                    for (WatchEvent event : events) {
                        WatchContext context = (WatchContext)event.context();
                        if (event.kind().equals(StandardWatchEventKind.ENTRY_MODIFY)) {
                            if (!context.getOldPath().getFileName().toString().equals(".lastmodified")) continue;
                            markerFileModified = true;
                            break;
                        }
                        if (event.kind().equals(StandardWatchEventKind.ENTRY_CREATE)) {
                            if (!context.getPath().getFileName().toString().equals(".lastmodified")) continue;
                            markerFileModified = true;
                            break;
                        }
                        if (event.kind().equals(StandardWatchEventKind.ENTRY_RENAME)) {
                            if (!context.getOldPath().getFileName().toString().equals(".lastmodified")) continue;
                            markerFileModified = true;
                            break;
                        }
                        if (!event.kind().equals(StandardWatchEventKind.ENTRY_DELETE) || !context.getOldPath().getFileName().toString().equals(".lastmodified")) continue;
                        markerFileModified = true;
                        break;
                    }
                    if (markerFileModified) {
                        wsExecutor.execute(wk, ConfigurationServiceImpl.this.localLastModifiedValue.get(), ConfigurationServiceImpl.this);
                    }
                    if (valid = wk.reset()) continue;
                    break;
                }
                catch (Exception exception) {
                }
            }
        }

        @Override
        public String getDescription() {
            return "Config File Watch Service";
        }
    }
}

