/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.inbox.backend.server;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ejb.Asynchronous;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import org.guvnor.inbox.backend.server.AsyncMailboxProcessOutgoing;
import org.guvnor.inbox.backend.server.InboxBackend;
import org.uberfire.commons.async.DescriptiveRunnable;
import org.uberfire.commons.async.DescriptiveThreadFactory;

@Singleton
@Startup
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class MailboxProcessOutgoingExecutorManager {
    @Inject
    private InboxBackend inboxBackend;
    private AtomicBoolean useExecService = new AtomicBoolean(false);
    private ExecutorService executorService = null;

    @Asynchronous
    public void execute(final AsyncMailboxProcessOutgoing mailboxProcessOutgoing) {
        if (this.useExecService.get()) {
            this.getExecutorService().execute((Runnable)new DescriptiveRunnable(){

                public void run() {
                    mailboxProcessOutgoing.execute(MailboxProcessOutgoingExecutorManager.this.inboxBackend);
                }

                public String getDescription() {
                    return mailboxProcessOutgoing.getDescription();
                }
            });
        } else {
            mailboxProcessOutgoing.execute(this.inboxBackend);
        }
    }

    private synchronized ExecutorService getExecutorService() {
        if (this.executorService == null) {
            this.executorService = Executors.newCachedThreadPool((ThreadFactory)new DescriptiveThreadFactory());
        }
        return this.executorService;
    }

    public void setInboxBackend(InboxBackend inboxBackend) {
        this.inboxBackend = inboxBackend;
        this.useExecService.set(true);
    }

    public void shutdown() {
        if (this.useExecService.get() && this.executorService != null) {
            this.executorService.shutdown();
            try {
                if (!this.executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                    this.executorService.shutdownNow();
                    if (!this.executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                        System.err.println("Pool did not terminate");
                    }
                }
            }
            catch (InterruptedException ie) {
                this.executorService.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }
}

