/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.client.editors.repository.wizard.pages;

import com.google.gwt.user.client.ui.Widget;
import javax.inject.Inject;
import org.guvnor.asset.management.client.editors.repository.wizard.CreateRepositoryWizardModel;
import org.guvnor.asset.management.client.editors.repository.wizard.pages.RepositoryStructurePageView;
import org.guvnor.asset.management.client.editors.repository.wizard.pages.RepositoryWizardPage;
import org.guvnor.asset.management.client.i18n.Constants;
import org.guvnor.asset.management.service.RepositoryStructureService;
import org.jboss.errai.bus.client.api.base.DefaultErrorCallback;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.client.callbacks.Callback;

public class RepositoryStructurePage
extends RepositoryWizardPage
implements RepositoryStructurePageView.Presenter {
    private RepositoryStructurePageView view;
    private boolean isProjectValid = false;
    private boolean isGroupIdValid = false;
    private boolean isArtifactIdValid = false;
    private boolean isValidVersion = false;
    private Caller<RepositoryStructureService> repositoryStructureService;

    @Inject
    public RepositoryStructurePage(RepositoryStructurePageView view, Caller<RepositoryStructureService> repositoryStructureService) {
        this.view = view;
        view.init(this);
        this.repositoryStructureService = repositoryStructureService;
    }

    public String getTitle() {
        return Constants.INSTANCE.RepositoryStructurePage();
    }

    public void isComplete(Callback<Boolean> callback) {
        boolean isComplete = this.structurePageWasVisited && this.isProjectValid && this.isGroupIdValid && this.isArtifactIdValid && this.isValidVersion;
        callback.callback((Object)isComplete);
    }

    @Override
    public void setModel(CreateRepositoryWizardModel model) {
        super.setModel(model);
        model.setConfigureRepository(this.view.isConfigureRepository());
        model.setMultiModule(this.view.isMultiModule());
    }

    public void initialise() {
    }

    public void prepareView() {
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    @Override
    public void setProjectName(String projectName) {
        this.model.setProjectName(projectName);
        this.view.setProjectName(projectName);
        this.view.clearProjectNameErrorMessage();
        this.isProjectValid = true;
    }

    @Override
    public void onProjectNameChange() {
        String projectName = this.view.getProjectName();
        String string = projectName = projectName != null ? projectName.trim() : null;
        if (projectName != null && !projectName.equals(this.view.getProjectName())) {
            this.view.setProjectName(projectName);
        }
        this.model.setProjectName(projectName);
        ((RepositoryStructureService)this.repositoryStructureService.call((RemoteCallback)new RemoteCallback<Boolean>(){

            public void callback(Boolean isValid) {
                if (isValid.booleanValue()) {
                    RepositoryStructurePage.this.view.clearProjectNameErrorMessage();
                } else {
                    RepositoryStructurePage.this.view.setProjectNameErrorMessage(Constants.INSTANCE.InvalidProjectName());
                }
                if (isValid != RepositoryStructurePage.this.isProjectValid) {
                    RepositoryStructurePage.this.isProjectValid = isValid;
                    RepositoryStructurePage.this.fireEvent();
                }
            }
        }, (ErrorCallback)new DefaultErrorCallback())).isValidProjectName(projectName);
    }

    @Override
    public void setProjectDescription(String projectDescription) {
        this.model.setProjectDescription(projectDescription);
        this.view.setProjectDescription(projectDescription);
    }

    @Override
    public void onProjectDescriptionChange() {
        this.model.setProjectDescription(this.view.getProjectDescription().trim());
    }

    @Override
    public void setGroupId(String groupId) {
        this.model.setGroupId(groupId);
        this.view.setGroupId(groupId);
        this.view.clearGroupIdErrorMessage();
        this.isGroupIdValid = true;
    }

    @Override
    public void onGroupIdChange() {
        String groupId = this.view.getGroupId();
        String string = groupId = groupId != null ? groupId.trim() : null;
        if (groupId != null && !groupId.equals(this.view.getGroupId())) {
            this.view.setGroupId(groupId);
        }
        this.model.setGroupId(groupId);
        ((RepositoryStructureService)this.repositoryStructureService.call((RemoteCallback)new RemoteCallback<Boolean>(){

            public void callback(Boolean isValid) {
                if (isValid.booleanValue()) {
                    RepositoryStructurePage.this.view.clearGroupIdErrorMessage();
                } else {
                    RepositoryStructurePage.this.view.setGroupIdErrorMessage(Constants.INSTANCE.InvalidGroupId());
                }
                if (isValid != RepositoryStructurePage.this.isGroupIdValid) {
                    RepositoryStructurePage.this.isGroupIdValid = isValid;
                    RepositoryStructurePage.this.fireEvent();
                }
            }
        }, (ErrorCallback)new DefaultErrorCallback())).isValidGroupId(groupId);
    }

    @Override
    public void setArtifactId(String artifactId) {
        this.model.setArtifactId(artifactId);
        this.view.setArtifactId(artifactId);
        this.view.clearArtifactIdErrorMessage();
        this.isArtifactIdValid = true;
    }

    @Override
    public void onArtifactIdChange() {
        String artifactId = this.view.getArtifactId();
        String string = artifactId = artifactId != null ? artifactId.trim() : null;
        if (artifactId != null && !artifactId.equals(this.view.getArtifactId())) {
            this.view.setArtifactId(artifactId);
        }
        this.model.setArtifactId(artifactId);
        ((RepositoryStructureService)this.repositoryStructureService.call((RemoteCallback)new RemoteCallback<Boolean>(){

            public void callback(Boolean isValid) {
                if (isValid.booleanValue()) {
                    RepositoryStructurePage.this.view.clearArtifactIdErrorMessage();
                } else {
                    RepositoryStructurePage.this.view.setArtifactIdErrorMessage(Constants.INSTANCE.InvalidArtifactId());
                }
                if (isValid != RepositoryStructurePage.this.isArtifactIdValid) {
                    RepositoryStructurePage.this.isArtifactIdValid = isValid;
                    RepositoryStructurePage.this.fireEvent();
                }
            }
        }, (ErrorCallback)new DefaultErrorCallback())).isValidArtifactId(artifactId);
    }

    @Override
    public void setConfigureRepository(boolean configureRepository) {
        this.model.setConfigureRepository(configureRepository);
        this.view.setConfigureRepository(configureRepository);
    }

    @Override
    public void setVersion(String version) {
        this.model.setVersion(version);
        this.view.setVersion(version);
        this.view.clearVersionErrorMessage();
        this.isValidVersion = true;
    }

    @Override
    public void onVersionChange() {
        String version = this.view.getVersion();
        String string = version = version != null ? version.trim() : null;
        if (version != null && !version.equals(this.view.getVersion())) {
            this.view.setVersion(version);
        }
        this.model.setVersion(version);
        ((RepositoryStructureService)this.repositoryStructureService.call((RemoteCallback)new RemoteCallback<Boolean>(){

            public void callback(Boolean isValid) {
                if (isValid.booleanValue()) {
                    RepositoryStructurePage.this.view.clearVersionErrorMessage();
                } else {
                    RepositoryStructurePage.this.view.setVersionErrorMessage(Constants.INSTANCE.InvalidVersion());
                }
                if (isValid != RepositoryStructurePage.this.isValidVersion) {
                    RepositoryStructurePage.this.isValidVersion = isValid;
                    RepositoryStructurePage.this.fireEvent();
                }
            }
        }, (ErrorCallback)new DefaultErrorCallback())).isValidVersion(version);
    }

    @Override
    public void onSingleModuleChange() {
        this.model.setMultiModule(!this.view.isSingleModule());
    }

    @Override
    public void onMultiModuleChange() {
        this.model.setMultiModule(this.view.isMultiModule());
    }

    @Override
    public void onConfigureRepositoryChange() {
        this.model.setConfigureRepository(this.view.isConfigureRepository());
    }
}

