/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.client.editors.repository.wizard.pages;

import com.google.gwt.user.client.ui.Widget;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.guvnor.asset.management.client.editors.repository.wizard.CreateRepositoryWizardModel;
import org.guvnor.asset.management.client.editors.repository.wizard.pages.RepositoryInfoPageView;
import org.guvnor.asset.management.client.editors.repository.wizard.pages.RepositoryWizardPage;
import org.guvnor.asset.management.client.i18n.Constants;
import org.guvnor.structure.client.editors.repository.RepositoryPreferences;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.RepositoryService;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.container.IOC;
import org.jboss.errai.ioc.client.container.IOCBeanDef;
import org.jboss.errai.ioc.client.container.IOCResolutionException;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.widgets.common.client.callbacks.DefaultErrorCallback;
import org.uberfire.ext.widgets.core.client.resources.i18n.CoreConstants;

public class RepositoryInfoPage
extends RepositoryWizardPage
implements RepositoryInfoPageView.Presenter {
    private RepositoryInfoPageView view;
    private Caller<OrganizationalUnitService> organizationalUnitService;
    private Caller<RepositoryService> repositoryService;
    private boolean isNameValid = false;
    private boolean isOUValid = false;
    private boolean isRepositoryStructurePageValid = false;
    private Map<String, OrganizationalUnit> availableOrganizationalUnits = new HashMap<String, OrganizationalUnit>();
    private boolean mandatoryOU = true;
    private boolean isManagedRepository = false;
    private RepositoryInfoPageHandler handler;

    @Inject
    public RepositoryInfoPage(RepositoryInfoPageView view, Caller<OrganizationalUnitService> organizationalUnitService, Caller<RepositoryService> repositoryService) {
        this.view = view;
        view.init(this);
        this.organizationalUnitService = organizationalUnitService;
        this.repositoryService = repositoryService;
    }

    public String getTitle() {
        return Constants.INSTANCE.RepositoryInfoPage();
    }

    public void isComplete(Callback<Boolean> callback) {
        boolean completed = this.mandatoryOU ? this.isNameValid && this.isOUValid : this.isNameValid;
        callback.callback((Object)completed);
    }

    public void initialise() {
    }

    public void prepareView() {
        this.init();
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void setHandler(RepositoryInfoPageHandler handler) {
        this.handler = handler;
    }

    @Override
    public void onNameChange() {
        String name = this.view.getName().trim();
        this.model.setRepositoryName(name);
        if (!name.equals(this.view.getName())) {
            this.view.setName(name);
        }
        ((RepositoryService)this.repositoryService.call((RemoteCallback)new RemoteCallback<Boolean>(){

            public void callback(Boolean isValid) {
                if (isValid.booleanValue()) {
                    RepositoryInfoPage.this.view.clearNameErrorMessage();
                } else {
                    RepositoryInfoPage.this.view.setNameErrorMessage(Constants.INSTANCE.InvalidRepositoryName());
                }
                if (isValid != RepositoryInfoPage.this.isNameValid) {
                    RepositoryInfoPage.this.isNameValid = isValid;
                    RepositoryInfoPage.this.refreshRepositoryStructurePageStatus();
                }
            }
        }, (ErrorCallback)new DefaultErrorCallback())).validateRepositoryName(this.model.getRepositoryName());
    }

    @Override
    public void onOUChange() {
        boolean newIsOUValid;
        String selectedOU = this.view.getOrganizationalUnitName();
        boolean bl = newIsOUValid = selectedOU != null && !"NOT_SELECTED".equals(selectedOU);
        if (this.mandatoryOU) {
            this.view.setValidOU(newIsOUValid);
        }
        this.model.setOrganizationalUnit(selectedOU != null ? this.availableOrganizationalUnits.get(selectedOU) : null);
        if (this.isOUValid != newIsOUValid) {
            this.isOUValid = newIsOUValid;
            this.refreshRepositoryStructurePageStatus();
        }
    }

    @Override
    public void onManagedRepositoryChange() {
        this.model.setManged(this.view.isManagedRepository());
        if (this.isManagedRepository != this.view.isManagedRepository()) {
            this.isManagedRepository = this.view.isManagedRepository();
            this.refreshRepositoryStructurePageStatus();
        }
    }

    private void refreshRepositoryStructurePageStatus() {
        boolean newIsRepositoryStructurePageValid;
        boolean bl = newIsRepositoryStructurePageValid = this.isManagedRepository && this.isNameValid && this.isOUValid;
        if (newIsRepositoryStructurePageValid != this.isRepositoryStructurePageValid) {
            this.isRepositoryStructurePageValid = newIsRepositoryStructurePageValid;
            if (this.handler != null) {
                this.handler.managedRepositoryStatusChanged(this.isRepositoryStructurePageValid);
            }
        }
        this.fireEvent();
    }

    @PostConstruct
    protected void init() {
        this.mandatoryOU = this.isOUMandatory();
        if (!this.mandatoryOU) {
            this.view.setVisibleOU(false);
        }
        ((OrganizationalUnitService)this.organizationalUnitService.call((RemoteCallback)new RemoteCallback<Collection<OrganizationalUnit>>(){

            public void callback(Collection<OrganizationalUnit> organizationalUnits) {
                RepositoryInfoPage.this.initOrganizationalUnits(organizationalUnits);
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                RepositoryInfoPage.this.view.alert(CoreConstants.INSTANCE.CantLoadOrganizationalUnits() + " \n" + message.toString());
                return false;
            }
        })).getOrganizationalUnits();
    }

    @Override
    public void setModel(CreateRepositoryWizardModel model) {
        super.setModel(model);
        model.setMandatoryOU(this.mandatoryOU);
        model.setManged(this.view.isManagedRepository());
    }

    public void enableManagedRepoCreation(boolean enable) {
        this.view.enabledManagedRepositoryCreation(enable);
    }

    protected boolean isOUMandatory() {
        try {
            IOCBeanDef beanDef = IOC.getBeanManager().lookupBean(RepositoryPreferences.class, new Annotation[0]);
            return beanDef == null || ((RepositoryPreferences)beanDef.getInstance()).isOUMandatory();
        }
        catch (IOCResolutionException iOCResolutionException) {
            return true;
        }
    }

    protected void initOrganizationalUnits(Collection<OrganizationalUnit> organizationalUnits) {
        ArrayList<Pair<String, String>> organizationalUnitsInfo = new ArrayList<Pair<String, String>>();
        if (organizationalUnits != null && !organizationalUnits.isEmpty()) {
            for (OrganizationalUnit organizationalUnit : organizationalUnits) {
                this.availableOrganizationalUnits.put(organizationalUnit.getName(), organizationalUnit);
                organizationalUnitsInfo.add((Pair<String, String>)new Pair((Object)organizationalUnit.getName(), (Object)organizationalUnit.getName()));
            }
        }
        this.view.initOrganizationalUnits(organizationalUnitsInfo);
    }

    public static interface RepositoryInfoPageHandler {
        public void managedRepositoryStatusChanged(boolean var1);
    }
}

