/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.client.editors.repository.wizard;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.asset.management.client.editors.repository.wizard.CreateRepositoryWizardModel;
import org.guvnor.asset.management.client.editors.repository.wizard.pages.RepositoryInfoPage;
import org.guvnor.asset.management.client.editors.repository.wizard.pages.RepositoryStructurePage;
import org.guvnor.asset.management.client.editors.repository.wizard.pages.RepositoryWizardPage;
import org.guvnor.asset.management.client.i18n.Constants;
import org.guvnor.asset.management.service.AssetManagementService;
import org.guvnor.asset.management.service.RepositoryStructureService;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.shared.security.KieWorkbenchACL;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryAlreadyExistsException;
import org.guvnor.structure.repositories.RepositoryService;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.security.shared.api.Role;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;
import org.uberfire.ext.widgets.core.client.resources.i18n.CoreConstants;
import org.uberfire.ext.widgets.core.client.wizards.AbstractWizard;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class CreateRepositoryWizard
extends AbstractWizard {
    private final List<WizardPage> pages = new ArrayList<WizardPage>();
    private RepositoryInfoPage infoPage;
    private RepositoryStructurePage structurePage;
    private CreateRepositoryWizardModel model = new CreateRepositoryWizardModel();
    private Caller<RepositoryService> repositoryService;
    private Caller<RepositoryStructureService> repositoryStructureService;
    private Caller<AssetManagementService> assetManagementService;
    private Event<NotificationEvent> notification;
    private KieWorkbenchACL kieACL;
    private SessionInfo sessionInfo;
    private Callback<Void> onCloseCallback = null;
    private boolean assetsManagementIsGranted = false;

    @Inject
    public CreateRepositoryWizard(RepositoryInfoPage infoPage, RepositoryStructurePage structurePage, CreateRepositoryWizardModel model, Caller<RepositoryService> repositoryService, Caller<RepositoryStructureService> repositoryStructureService, Caller<AssetManagementService> assetManagementService, Event<NotificationEvent> notification, KieWorkbenchACL kieACL, SessionInfo sessionInfo) {
        this.infoPage = infoPage;
        this.structurePage = structurePage;
        this.model = model;
        this.repositoryService = repositoryService;
        this.repositoryStructureService = repositoryStructureService;
        this.assetManagementService = assetManagementService;
        this.notification = notification;
        this.kieACL = kieACL;
        this.sessionInfo = sessionInfo;
    }

    @PostConstruct
    public void setupPages() {
        this.pages.add(this.infoPage);
        this.infoPage.initialise();
        this.structurePage.initialise();
        this.infoPage.setModel(this.model);
        this.structurePage.setModel(this.model);
        this.infoPage.setHandler(new RepositoryInfoPage.RepositoryInfoPageHandler(){

            @Override
            public void managedRepositoryStatusChanged(boolean status) {
                CreateRepositoryWizard.this.managedRepositorySelected(status);
            }
        });
        this.setAssetsManagementGrant();
    }

    public List<WizardPage> getPages() {
        return this.pages;
    }

    public Widget getPageWidget(int pageNumber) {
        RepositoryWizardPage page = (RepositoryWizardPage)this.pages.get(pageNumber);
        Widget w = page.asWidget();
        return w;
    }

    public String getTitle() {
        return Constants.INSTANCE.NewRepository();
    }

    public int getPreferredHeight() {
        return 600;
    }

    public int getPreferredWidth() {
        return 700;
    }

    public void isComplete(Callback<Boolean> callback) {
        final int[] unCompletedPages = new int[]{this.pages.size()};
        final boolean[] completed = new boolean[]{false};
        for (WizardPage page : this.pages) {
            page.isComplete((Callback)new Callback<Boolean>(){

                public void callback(Boolean result) {
                    if (Boolean.TRUE.equals(result)) {
                        unCompletedPages[0] = unCompletedPages[0] - 1;
                        if (unCompletedPages[0] == 0) {
                            completed[0] = true;
                        }
                    }
                }
            });
        }
        callback.callback((Object)completed[0]);
    }

    public void complete() {
        this.doComplete();
    }

    public void close() {
        super.close();
        this.invokeOnCloseCallback();
    }

    public void onCloseCallback(Callback<Void> callback) {
        this.onCloseCallback = callback;
    }

    private void managedRepositorySelected(boolean selected) {
        if (this.assetsManagementIsGranted) {
            boolean updateDefaultValues = false;
            if (selected && !this.pages.contains(this.structurePage)) {
                this.pages.add(this.structurePage);
                updateDefaultValues = true;
            } else {
                this.pages.remove(this.structurePage);
            }
            super.start();
            if (updateDefaultValues) {
                this.setStructureDefaultValues();
            }
        }
    }

    public void pageSelected(int pageNumber) {
        super.pageSelected(pageNumber);
        if (pageNumber == 1) {
            this.infoPage.setStructurePageWasVisited(true);
            this.structurePage.setStructurePageWasVisited(true);
            this.setStructureDefaultValues();
        }
    }

    private void doComplete() {
        ((RepositoryService)this.repositoryService.call((RemoteCallback)new RemoteCallback<String>(){

            public void callback(String normalizedName) {
                if (!CreateRepositoryWizard.this.model.getRepositoryName().equals(normalizedName)) {
                    if (!Window.confirm((String)(CoreConstants.INSTANCE.RepositoryNameInvalid() + " \"" + normalizedName + "\". " + CoreConstants.INSTANCE.DoYouAgree()))) {
                        return;
                    }
                    String unNormalizedName = CreateRepositoryWizard.this.model.getRepositoryName();
                    CreateRepositoryWizard.this.model.setRepositoryName(normalizedName);
                    if (unNormalizedName.equals(CreateRepositoryWizard.this.model.getProjectName())) {
                        CreateRepositoryWizard.this.model.setProjectName(normalizedName);
                    }
                    if (unNormalizedName.equals(CreateRepositoryWizard.this.model.getArtifactId())) {
                        CreateRepositoryWizard.this.model.setArtifactId(normalizedName);
                    }
                }
                CreateRepositoryWizard.this.parentComplete();
                String scheme = "git";
                String alias = CreateRepositoryWizard.this.model.getRepositoryName().trim();
                HashMap<String, Boolean> env = new HashMap<String, Boolean>(3);
                env.put("managed", CreateRepositoryWizard.this.assetsManagementIsGranted && CreateRepositoryWizard.this.model.isManged());
                CreateRepositoryWizard.this.showBusyIndicator(Constants.INSTANCE.CreatingRepository());
                ((RepositoryService)CreateRepositoryWizard.this.repositoryService.call((RemoteCallback)new RemoteCallback<Repository>(){

                    public void callback(Repository repository) {
                        CreateRepositoryWizard.this.hideBusyIndicator();
                        CreateRepositoryWizard.this.notification.fire((Object)new NotificationEvent(Constants.INSTANCE.RepoCreationSuccess()));
                        CreateRepositoryWizard.this.getRepositoryCreatedSuccessCallback().callback((Object)repository);
                    }
                }, (ErrorCallback)new ErrorCallback<Message>(){

                    public boolean error(Message message, Throwable throwable) {
                        try {
                            CreateRepositoryWizard.this.hideBusyIndicator();
                            throw throwable;
                        }
                        catch (RepositoryAlreadyExistsException ex) {
                            CreateRepositoryWizard.this.showErrorPopup(CoreConstants.INSTANCE.RepoAlreadyExists());
                        }
                        catch (Throwable ex) {
                            CreateRepositoryWizard.this.showErrorPopup(CoreConstants.INSTANCE.RepoCreationFail() + " \n" + throwable.getMessage());
                        }
                        CreateRepositoryWizard.this.invokeOnCloseCallback();
                        return true;
                    }
                })).createRepository(CreateRepositoryWizard.this.model.getOrganizationalUnit(), "git", alias, env);
            }
        })).normalizeRepositoryName(this.model.getRepositoryName());
    }

    private void parentComplete() {
        super.complete();
    }

    private RemoteCallback<Repository> getRepositoryCreatedSuccessCallback() {
        return new RemoteCallback<Repository>(){

            public void callback(final Repository repository) {
                if (CreateRepositoryWizard.this.model.isManged()) {
                    CreateRepositoryWizard.this.showBusyIndicator(Constants.INSTANCE.InitializingRepository());
                    POM pom = new POM();
                    pom.setName(CreateRepositoryWizard.this.model.getProjectName());
                    pom.setDescription(CreateRepositoryWizard.this.model.getProjectDescription());
                    pom.getGav().setGroupId(CreateRepositoryWizard.this.model.getGroupId());
                    pom.getGav().setArtifactId(CreateRepositoryWizard.this.model.getArtifactId());
                    pom.getGav().setVersion(CreateRepositoryWizard.this.model.getVersion());
                    String url = GWT.getModuleBaseURL();
                    String baseUrl = url.replace(GWT.getModuleName() + "/", "");
                    ((RepositoryStructureService)CreateRepositoryWizard.this.repositoryStructureService.call((RemoteCallback)new RemoteCallback<Path>(){

                        public void callback(Path path) {
                            CreateRepositoryWizard.this.hideBusyIndicator();
                            CreateRepositoryWizard.this.notification.fire((Object)new NotificationEvent(Constants.INSTANCE.RepoInitializationSuccess()));
                            CreateRepositoryWizard.this.getRepositoryInitializedSuccessCallback().callback((Object)new Pair((Object)repository, (Object)path));
                        }
                    }, (ErrorCallback)new ErrorCallback<Message>(){

                        public boolean error(Message message, Throwable throwable) {
                            CreateRepositoryWizard.this.hideBusyIndicator();
                            CreateRepositoryWizard.this.showErrorPopup(Constants.INSTANCE.RepoInitializationFail() + " \n" + throwable.getMessage());
                            CreateRepositoryWizard.this.invokeOnCloseCallback();
                            return true;
                        }
                    })).initRepositoryStructure(pom, baseUrl, repository, CreateRepositoryWizard.this.model.isMultiModule());
                } else {
                    CreateRepositoryWizard.this.invokeOnCloseCallback();
                }
            }
        };
    }

    private RemoteCallback<Pair<Repository, Path>> getRepositoryInitializedSuccessCallback() {
        return new RemoteCallback<Pair<Repository, Path>>(){

            public void callback(Pair<Repository, Path> pair) {
                if (CreateRepositoryWizard.this.model.isConfigureRepository()) {
                    ((AssetManagementService)CreateRepositoryWizard.this.assetManagementService.call((RemoteCallback)new RemoteCallback<Void>(){

                        public void callback(Void o) {
                            CreateRepositoryWizard.this.notification.fire((Object)new NotificationEvent(Constants.INSTANCE.RepoConfigurationStarted()));
                            CreateRepositoryWizard.this.invokeOnCloseCallback();
                        }
                    }, (ErrorCallback)new ErrorCallback<Message>(){

                        public boolean error(Message message, Throwable throwable) {
                            CreateRepositoryWizard.this.showErrorPopup(Constants.INSTANCE.RepoConfigurationStartFailed() + " \n" + throwable.getMessage());
                            CreateRepositoryWizard.this.invokeOnCloseCallback();
                            return true;
                        }
                    })).configureRepository(((Repository)pair.getK1()).getAlias(), "master", "dev", "release", CreateRepositoryWizard.this.normalizeVersionNumber(CreateRepositoryWizard.this.model.getVersion()));
                } else {
                    CreateRepositoryWizard.this.invokeOnCloseCallback();
                }
            }
        };
    }

    private String normalizeVersionNumber(String version) {
        String string = version = version != null ? version.trim() : null;
        if (version != null && version.contains("-SNAPSHOT")) {
            return version.replace("-SNAPSHOT", "");
        }
        return version;
    }

    private void invokeOnCloseCallback() {
        if (this.onCloseCallback != null) {
            this.onCloseCallback.callback(null);
        }
    }

    private void showBusyIndicator(String message) {
        BusyPopup.showMessage((String)message);
    }

    private void hideBusyIndicator() {
        BusyPopup.close();
    }

    private void showErrorPopup(String message) {
        ErrorPopup.showMessage((String)message);
    }

    private void setStructureDefaultValues() {
        if (this.model.getRepositoryName() != null) {
            this.structurePage.setProjectName(this.model.getRepositoryName());
            this.structurePage.setArtifactId(this.model.getRepositoryName());
        }
        if (this.model.getOrganizationalUnit() != null) {
            this.structurePage.setGroupId(this.model.getOrganizationalUnit().getDefaultGroupId());
        }
        this.structurePage.setProjectDescription(null);
        this.structurePage.setVersion("1.0.0-SNAPSHOT");
        this.structurePage.fireEvent();
    }

    private void setAssetsManagementGrant() {
        Set grantedRoles = this.kieACL.getGrantedRoles("wb_configure_repository");
        this.assetsManagementIsGranted = false;
        if (this.sessionInfo != null && this.sessionInfo.getIdentity() != null && this.sessionInfo.getIdentity().getRoles() != null) {
            for (Role role : this.sessionInfo.getIdentity().getRoles()) {
                if (!grantedRoles.contains(role.getName())) continue;
                this.assetsManagementIsGranted = true;
                break;
            }
        }
        this.infoPage.enableManagedRepoCreation(this.assetsManagementIsGranted);
    }
}

