/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.client.editors.repository.structure;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.asset.management.client.editors.project.structure.widgets.ProjectModuleRow;
import org.guvnor.asset.management.client.editors.project.structure.widgets.ProjectModulesView;
import org.guvnor.asset.management.client.editors.project.structure.widgets.RepositoryStructureDataView;
import org.guvnor.asset.management.client.editors.repository.structure.RepositoryStructureView;
import org.guvnor.asset.management.client.i18n.Constants;
import org.guvnor.asset.management.model.RepositoryStructureModel;
import org.guvnor.asset.management.service.AssetManagementService;
import org.guvnor.asset.management.service.RepositoryStructureService;
import org.guvnor.common.services.project.builder.model.BuildResults;
import org.guvnor.common.services.project.builder.service.BuildService;
import org.guvnor.common.services.project.context.ProjectContext;
import org.guvnor.common.services.project.context.ProjectContextChangeEvent;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.model.ProjectWizard;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.common.services.shared.security.impl.KieWorkbenchACLImpl;
import org.guvnor.structure.repositories.Repository;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.container.IOC;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.events.BeforeClosePlaceEvent;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.ConcurrentChangePopup;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.ext.widgets.common.client.common.popups.YesNoCancelPopup;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;
import org.uberfire.ext.widgets.common.client.resources.i18n.CommonConstants;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnFocus;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.MenuVisitor;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchScreen(identifier="repositoryStructureScreen")
public class RepositoryStructurePresenter
implements RepositoryStructureView.Presenter,
RepositoryStructureDataView.Presenter,
ProjectModulesView.Presenter {
    private RepositoryStructureView view;
    @Inject
    private Caller<RepositoryStructureService> repositoryStructureService;
    @Inject
    private Caller<POMService> pomService;
    @Inject
    private Caller<BuildService> buildServiceCaller;
    @Inject
    private Event<BuildResults> buildResultsEvent;
    @Inject
    private Event<NotificationEvent> notificationEvent;
    @Inject
    private Event<ChangeTitleWidgetEvent> changeTitleWidgetEvent;
    @Inject
    private Event<BeforeClosePlaceEvent> beforeCloseEvent;
    @Inject
    private Event<ProjectContextChangeEvent> contextChangeEvent;
    @Inject
    private KieWorkbenchACLImpl kieACL;
    @Inject
    private PlaceManager placeManager;
    @Inject
    private ProjectContext workbenchContext;
    @Inject
    private ProjectWizard wizard;
    @Inject
    protected Event<ProjectContextChangeEvent> contextChangedEvent;
    @Inject
    protected Caller<AssetManagementService> assetManagementServices;
    @Inject
    protected ErrorPopupPresenter errorPopup;
    private RepositoryStructureModel model;
    private Project project;
    private Project lastAddedModule;
    private Project lastDeletedModule;
    private Repository repository;
    private String branch;
    private ObservablePath pathToRepositoryStructure;
    private PlaceRequest placeRequest;
    private ObservablePath.OnConcurrentUpdateEvent concurrentUpdateSessionInfo = null;
    private ListDataProvider<ProjectModuleRow> dataProvider = new ListDataProvider();
    private Menus menus;
    private MenuItem configure;
    private MenuItem release;
    private MenuItem promote;
    private boolean promoteIsGranted = false;
    private boolean configureIsGranted = false;
    private boolean releaseIsGranted = false;

    @Inject
    public RepositoryStructurePresenter(RepositoryStructureView view) {
        this.view = view;
        view.setPresenter(this);
        view.getDataView().setPresenter(this);
        view.getModulesView().setPresenter(this);
    }

    @OnStartup
    public void onStartup(PlaceRequest placeRequest) {
        this.placeRequest = placeRequest;
        this.processContextChange(this.workbenchContext.getActiveRepository(), this.workbenchContext.getActiveProject());
        this.makeMenuBar();
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return Constants.INSTANCE.RepositoryStructure();
    }

    @WorkbenchPartView
    public IsWidget asWidget() {
        return this.view.asWidget();
    }

    @OnClose
    public void onClose() {
        this.concurrentUpdateSessionInfo = null;
        if (this.pathToRepositoryStructure != null) {
            this.pathToRepositoryStructure.dispose();
        }
    }

    @OnFocus
    public void onFocus() {
        this.dataProvider.flush();
        this.dataProvider.refresh();
    }

    private void onContextChange(@Observes ProjectContextChangeEvent event) {
        this.processContextChange(event.getRepository(), event.getProject());
    }

    private void processContextChange(Repository repository, Project project) {
        boolean repoOrBranchChanged = false;
        if (repository == null) {
            this.clearView();
            this.view.setModulesViewVisible(false);
            this.enableActions(false);
        } else {
            repoOrBranchChanged = this.repositoryOrBranchChanged(repository);
            if (repoOrBranchChanged || project != null && !project.equals((Object)this.project)) {
                this.repository = repository;
                this.branch = repository != null ? repository.getCurrentBranch() : null;
                this.project = project;
                if (repoOrBranchChanged || (this.lastAddedModule == null || !this.lastAddedModule.equals((Object)project)) && this.lastDeletedModule == null) {
                    this.init();
                }
                this.lastAddedModule = null;
                this.lastDeletedModule = null;
            }
        }
    }

    private void init() {
        this.view.showBusyIndicator(Constants.INSTANCE.Loading());
        this.clearView();
        ((RepositoryStructureService)this.repositoryStructureService.call(this.getLoadModelSuccessCallback(), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).load(this.repository);
    }

    private RemoteCallback<RepositoryStructureModel> getLoadModelSuccessCallback() {
        return new RemoteCallback<RepositoryStructureModel>(){

            public void callback(RepositoryStructureModel model) {
                RepositoryStructurePresenter.this.view.hideBusyIndicator();
                RepositoryStructurePresenter.this.model = model;
                boolean initialized = false;
                RepositoryStructurePresenter.this.dataProvider.getList().clear();
                if (RepositoryStructurePresenter.this.pathToRepositoryStructure != null) {
                    RepositoryStructurePresenter.this.pathToRepositoryStructure.dispose();
                }
                RepositoryStructurePresenter.this.concurrentUpdateSessionInfo = null;
                if (model == null) {
                    RepositoryStructurePresenter.this.model = new RepositoryStructureModel();
                    RepositoryStructurePresenter.this.view.getDataView().setMode(RepositoryStructureDataView.ViewMode.CREATE_STRUCTURE);
                    RepositoryStructurePresenter.this.view.getModulesView().setMode(ProjectModulesView.ViewMode.MODULES_VIEW);
                    RepositoryStructurePresenter.this.view.setModel(RepositoryStructurePresenter.this.model);
                    RepositoryStructurePresenter.this.view.setModulesViewVisible(false);
                    RepositoryStructurePresenter.this.enableAssetsManagementMenu(false);
                    RepositoryStructurePresenter.this.pathToRepositoryStructure = null;
                } else if (model.isMultiModule()) {
                    RepositoryStructurePresenter.this.view.getDataView().setMode(RepositoryStructureDataView.ViewMode.EDIT_MULTI_MODULE_PROJECT);
                    RepositoryStructurePresenter.this.view.getModulesView().setMode(ProjectModulesView.ViewMode.MODULES_VIEW);
                    RepositoryStructurePresenter.this.view.setModel(model);
                    RepositoryStructurePresenter.this.view.setModulesViewVisible(true);
                    initialized = true;
                    RepositoryStructurePresenter.this.pathToRepositoryStructure = ((ObservablePath)IOC.getBeanManager().lookupBean(ObservablePath.class, new Annotation[0]).getInstance()).wrap(model.getPathToPOM());
                    RepositoryStructurePresenter.this.updateModulesList(model.getModules());
                    RepositoryStructurePresenter.this.enableAssetsManagementMenu(true);
                } else if (model.isSingleProject()) {
                    RepositoryStructurePresenter.this.view.getDataView().setMode(RepositoryStructureDataView.ViewMode.EDIT_SINGLE_MODULE_PROJECT);
                    RepositoryStructurePresenter.this.view.getModulesView().setMode(ProjectModulesView.ViewMode.PROJECTS_VIEW);
                    RepositoryStructurePresenter.this.view.setModel(model);
                    RepositoryStructurePresenter.this.view.setModulesViewVisible(false);
                    initialized = true;
                    RepositoryStructurePresenter.this.pathToRepositoryStructure = ((ObservablePath)IOC.getBeanManager().lookupBean(ObservablePath.class, new Annotation[0]).getInstance()).wrap(((Project)model.getOrphanProjects().get(0)).getPomXMLPath());
                    RepositoryStructurePresenter.this.enableAssetsManagementMenu(true);
                } else {
                    RepositoryStructurePresenter.this.view.getDataView().setMode(RepositoryStructureDataView.ViewMode.EDIT_UNMANAGED_REPOSITORY);
                    RepositoryStructurePresenter.this.view.getModulesView().setMode(ProjectModulesView.ViewMode.PROJECTS_VIEW);
                    RepositoryStructurePresenter.this.view.setModulesViewVisible(true);
                    initialized = true;
                    RepositoryStructurePresenter.this.enableAssetsManagementMenu(false);
                    RepositoryStructurePresenter.this.view.setModel(model);
                    RepositoryStructurePresenter.this.updateProjectsList(model.getOrphanProjects());
                }
                RepositoryStructurePresenter.this.addStructureChangeListeners();
                RepositoryStructurePresenter.this.updateEditorTitle(initialized);
            }
        };
    }

    private void reload() {
        this.concurrentUpdateSessionInfo = null;
        this.init();
    }

    private void initRepositoryStructure() {
        if (this.model != null) {
            if (this.model.isMultiModule()) {
                this.view.showBusyIndicator(Constants.INSTANCE.CreatingRepositoryStructure());
                ((RepositoryStructureService)this.repositoryStructureService.call((RemoteCallback)new RemoteCallback<Path>(){

                    public void callback(Path response) {
                        RepositoryStructurePresenter.this.view.hideBusyIndicator();
                        RepositoryStructurePresenter.this.init();
                    }
                }, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).initRepositoryStructure(new GAV(this.view.getDataView().getGroupId(), this.view.getDataView().getArtifactId(), this.view.getDataView().getVersionId()), this.repository);
            } else if (this.model.isSingleProject()) {
                this.wizard.initialise(new POM());
                this.wizard.start((Callback)new Callback<Project>(){

                    public void callback(Project result) {
                        RepositoryStructurePresenter.this.lastAddedModule = result;
                        if (result != null) {
                            RepositoryStructurePresenter.this.view.showBusyIndicator(Constants.INSTANCE.CreatingRepositoryStructure());
                            ((RepositoryStructureService)RepositoryStructurePresenter.this.repositoryStructureService.call((RemoteCallback)new RemoteCallback<Repository>(){

                                public void callback(Repository repository) {
                                    RepositoryStructurePresenter.this.view.hideBusyIndicator();
                                    RepositoryStructurePresenter.this.repository = repository;
                                    RepositoryStructurePresenter.this.init();
                                }
                            }, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)RepositoryStructurePresenter.this.view))).initRepository(RepositoryStructurePresenter.this.repository, true);
                        }
                    }
                }, false);
            } else if (!this.model.isManaged().booleanValue()) {
                this.view.showBusyIndicator(Constants.INSTANCE.CreatingRepositoryStructure());
                ((RepositoryStructureService)this.repositoryStructureService.call((RemoteCallback)new RemoteCallback<Repository>(){

                    public void callback(Repository repository) {
                        RepositoryStructurePresenter.this.view.hideBusyIndicator();
                        RepositoryStructurePresenter.this.repository = repository;
                        RepositoryStructurePresenter.this.init();
                    }
                }, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).initRepository(this.repository, false);
            }
        }
    }

    private void updateEditorTitle(boolean initialized) {
        if (this.repository == null) {
            this.changeTitleWidgetEvent.fire((Object)new ChangeTitleWidgetEvent(this.placeRequest, Constants.INSTANCE.RepositoryNotSelected()));
        } else if (!initialized) {
            this.changeTitleWidgetEvent.fire((Object)new ChangeTitleWidgetEvent(this.placeRequest, Constants.INSTANCE.UnInitializedStructure(this.getRepositoryLabel(this.repository))));
        } else if (this.model.isMultiModule()) {
            this.changeTitleWidgetEvent.fire((Object)new ChangeTitleWidgetEvent(this.placeRequest, Constants.INSTANCE.RepositoryStructureWithName(this.getRepositoryLabel(this.repository) + "\u2192 " + this.model.getPOM().getGav().getArtifactId() + ":" + this.model.getPOM().getGav().getGroupId() + ":" + this.model.getPOM().getGav().getVersion())));
        } else if (this.model.isSingleProject()) {
            this.changeTitleWidgetEvent.fire((Object)new ChangeTitleWidgetEvent(this.placeRequest, Constants.INSTANCE.RepositoryStructureWithName(this.getRepositoryLabel(this.repository) + "\u2192 " + ((Project)this.model.getOrphanProjects().get(0)).getProjectName())));
        } else {
            this.changeTitleWidgetEvent.fire((Object)new ChangeTitleWidgetEvent(this.placeRequest, Constants.INSTANCE.UnmanagedRepository(this.getRepositoryLabel(this.repository))));
        }
    }

    private String getRepositoryLabel(Repository repository) {
        return repository != null ? repository.getAlias() + " (" + repository.getCurrentBranch() + ") " : "";
    }

    private void addStructureChangeListeners() {
        if (this.pathToRepositoryStructure != null) {
            this.pathToRepositoryStructure.onConcurrentUpdate((ParameterizedCommand)new ParameterizedCommand<ObservablePath.OnConcurrentUpdateEvent>(){

                public void execute(ObservablePath.OnConcurrentUpdateEvent eventInfo) {
                    RepositoryStructurePresenter.this.concurrentUpdateSessionInfo = eventInfo;
                }
            });
            this.pathToRepositoryStructure.onConcurrentRename((ParameterizedCommand)new ParameterizedCommand<ObservablePath.OnConcurrentRenameEvent>(){

                public void execute(ObservablePath.OnConcurrentRenameEvent info) {
                    ConcurrentChangePopup.newConcurrentRename((Path)info.getSource(), (Path)info.getTarget(), (User)info.getIdentity(), (Command)new Command(){

                        public void execute() {
                            RepositoryStructurePresenter.this.enableActions(false);
                        }
                    }, (Command)new Command(){

                        public void execute() {
                            RepositoryStructurePresenter.this.reload();
                        }
                    }).show();
                }
            });
            this.pathToRepositoryStructure.onConcurrentDelete((ParameterizedCommand)new ParameterizedCommand<ObservablePath.OnConcurrentDelete>(){

                public void execute(ObservablePath.OnConcurrentDelete info) {
                    ConcurrentChangePopup.newConcurrentDelete((Path)info.getPath(), (User)info.getIdentity(), (Command)new Command(){

                        public void execute() {
                            RepositoryStructurePresenter.this.enableActions(false);
                        }
                    }, (Command)new Command(){

                        public void execute() {
                            RepositoryStructurePresenter.this.placeManager.closePlace("repositoryStructureScreen");
                        }
                    }).show();
                }
            });
        }
    }

    private void updateModulesList(List<String> modules) {
        if (modules != null) {
            for (String module : this.model.getModules()) {
                this.dataProvider.getList().add(new ProjectModuleRow(module));
            }
        }
    }

    private void updateProjectsList(List<Project> projects) {
        if (projects != null) {
            for (Project project : projects) {
                this.dataProvider.getList().add(new ProjectModuleRow(project.getProjectName()));
            }
        }
    }

    private void enableActions(boolean value) {
        this.view.getModulesView().enableActions(value);
    }

    private void clearView() {
        this.view.getDataView().clear();
        this.dataProvider.getList().clear();
        this.enableActions(true);
    }

    @Override
    public void onAddModule() {
        POM pom = new POM();
        if (this.model.isMultiModule()) {
            GAV parentGAV = new GAV();
            parentGAV.setGroupId(this.view.getDataView().getGroupId());
            parentGAV.setVersion(this.view.getDataView().getVersionId());
            pom.setParent(parentGAV);
        }
        this.wizard.initialise(pom);
        this.wizard.start(this.getModuleAddedSuccessCallback(), false);
    }

    private Callback<Project> getModuleAddedSuccessCallback() {
        return new Callback<Project>(){

            public void callback(final Project _project) {
                RepositoryStructurePresenter.this.lastAddedModule = _project;
                if (_project != null) {
                    if (RepositoryStructurePresenter.this.model.isMultiModule()) {
                        RepositoryStructurePresenter.this.view.showBusyIndicator(Constants.INSTANCE.Loading());
                        ((RepositoryStructureService)RepositoryStructurePresenter.this.repositoryStructureService.call((RemoteCallback)new RemoteCallback<RepositoryStructureModel>(){

                            public void callback(RepositoryStructureModel _model) {
                                RepositoryStructurePresenter.this.view.hideBusyIndicator();
                                if (_model != null) {
                                    RepositoryStructurePresenter.this.model.setPOM(_model.getPOM());
                                    RepositoryStructurePresenter.this.model.setPOMMetaData(_model.getPOMMetaData());
                                    RepositoryStructurePresenter.this.model.setModules(_model.getModules());
                                    RepositoryStructurePresenter.this.model.getModulesProject().put(_project.getProjectName(), _project);
                                    RepositoryStructurePresenter.this.addToModulesList(_project);
                                }
                            }
                        }, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)RepositoryStructurePresenter.this.view))).load(RepositoryStructurePresenter.this.repository, false);
                    } else {
                        RepositoryStructurePresenter.this.view.showBusyIndicator(Constants.INSTANCE.Loading());
                        ((POMService)RepositoryStructurePresenter.this.pomService.call((RemoteCallback)new RemoteCallback<POM>(){

                            public void callback(POM _pom) {
                                RepositoryStructurePresenter.this.view.hideBusyIndicator();
                                RepositoryStructurePresenter.this.model.getOrphanProjects().add(_project);
                                RepositoryStructurePresenter.this.model.getOrphanProjectsPOM().put(_project.getSignatureId(), _pom);
                                RepositoryStructurePresenter.this.addToModulesList(_project);
                            }
                        }, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)RepositoryStructurePresenter.this.view))).load(_project.getPomXMLPath());
                    }
                }
            }
        };
    }

    @Override
    public void addDataDisplay(HasData<ProjectModuleRow> display) {
        this.dataProvider.addDataDisplay(display);
    }

    @Override
    public void onDeleteModule(ProjectModuleRow moduleRow) {
        final Project project = this.getSelectedModule(moduleRow.getName());
        String message = null;
        if (project != null) {
            message = this.model.isMultiModule() ? Constants.INSTANCE.ConfirmModuleDeletion(moduleRow.getName()) : Constants.INSTANCE.ConfirmProjectDeletion(moduleRow.getName());
            YesNoCancelPopup yesNoCancelPopup = YesNoCancelPopup.newYesNoCancelPopup((String)CommonConstants.INSTANCE.Information(), (String)message, (Command)new Command(){

                public void execute() {
                    RepositoryStructurePresenter.this.deleteSelectedModule(project);
                }
            }, (String)CommonConstants.INSTANCE.YES(), (ButtonType)ButtonType.DANGER, (IconType)IconType.TRASH, (Command)new Command(){

                public void execute() {
                }
            }, null, (ButtonType)ButtonType.DEFAULT, null, (Command)new Command(){

                public void execute() {
                }
            }, null, (ButtonType)ButtonType.DEFAULT, null);
            yesNoCancelPopup.setClosable(false);
            yesNoCancelPopup.show();
        }
    }

    private void deleteSelectedModule(Project project) {
        this.view.showBusyIndicator(Constants.INSTANCE.Deleting());
        this.lastDeletedModule = project;
        ((RepositoryStructureService)this.repositoryStructureService.call(this.getModuleDeletedSuccessCallback(project), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).delete(project.getPomXMLPath(), "Module removed");
    }

    private RemoteCallback<Void> getModuleDeletedSuccessCallback(final Project _project) {
        return new RemoteCallback<Void>(){

            public void callback(Void response) {
                if (_project != null) {
                    if (RepositoryStructurePresenter.this.model.isMultiModule()) {
                        RepositoryStructurePresenter.this.view.showBusyIndicator(Constants.INSTANCE.Loading());
                        ((RepositoryStructureService)RepositoryStructurePresenter.this.repositoryStructureService.call((RemoteCallback)new RemoteCallback<RepositoryStructureModel>(){

                            public void callback(RepositoryStructureModel _model) {
                                RepositoryStructurePresenter.this.view.hideBusyIndicator();
                                if (_model != null) {
                                    RepositoryStructurePresenter.this.model.setPOM(_model.getPOM());
                                    RepositoryStructurePresenter.this.model.setPOMMetaData(_model.getPOMMetaData());
                                    RepositoryStructurePresenter.this.model.setModules(_model.getModules());
                                    RepositoryStructurePresenter.this.model.getModulesProject().remove(_project.getProjectName());
                                    RepositoryStructurePresenter.this.removeFromModulesList(_project.getProjectName());
                                }
                            }
                        }, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)RepositoryStructurePresenter.this.view))).load(RepositoryStructurePresenter.this.repository, false);
                    } else {
                        RepositoryStructurePresenter.this.model.getOrphanProjects().remove(_project);
                        RepositoryStructurePresenter.this.model.getOrphanProjectsPOM().remove(_project.getSignatureId());
                        RepositoryStructurePresenter.this.removeFromModulesList(_project.getProjectName());
                    }
                }
            }
        };
    }

    @Override
    public void onEditModule(ProjectModuleRow moduleRow) {
        Project project = this.getSelectedModule(moduleRow.getName());
        if (project != null) {
            this.contextChangeEvent.fire((Object)new ProjectContextChangeEvent(this.workbenchContext.getActiveOrganizationalUnit(), this.repository, project));
            this.placeManager.goTo("projectScreen");
        }
    }

    @Override
    public void onArtifactIdChange(String artifactId) {
    }

    @Override
    public void onGroupIdChange(String groupId) {
    }

    @Override
    public void onVersionChange(String version) {
    }

    @Override
    public void onProjectModeChange() {
    }

    @Override
    public void onInitRepositoryStructure() {
        this.initRepositoryStructure();
    }

    @Override
    public void onSaveRepositoryStructure() {
        if (this.model.getPOM() != null) {
            YesNoCancelPopup yesNoCancelPopup = YesNoCancelPopup.newYesNoCancelPopup((String)CommonConstants.INSTANCE.Information(), (String)Constants.INSTANCE.ConfirmSaveRepositoryStructure(), (Command)new Command(){

                public void execute() {
                    RepositoryStructurePresenter.this.saveRepositoryStructure();
                }
            }, (String)CommonConstants.INSTANCE.YES(), (ButtonType)ButtonType.PRIMARY, (IconType)IconType.SAVE, (Command)new Command(){

                public void execute() {
                }
            }, null, (ButtonType)ButtonType.DEFAULT, null, (Command)new Command(){

                public void execute() {
                }
            }, null, (ButtonType)ButtonType.DEFAULT, null);
            yesNoCancelPopup.setClosable(false);
            yesNoCancelPopup.show();
        }
    }

    private void saveRepositoryStructure() {
        if (this.model.getPOM() != null) {
            this.model.getPOM().getGav().setGroupId(this.view.getDataView().getGroupId());
            this.model.getPOM().getGav().setArtifactId(this.view.getDataView().getArtifactId());
            this.model.getPOM().getGav().setVersion(this.view.getDataView().getVersionId());
            this.view.showBusyIndicator(Constants.INSTANCE.Saving());
            ((RepositoryStructureService)this.repositoryStructureService.call((RemoteCallback)new RemoteCallback<Void>(){

                public void callback(Void response) {
                    RepositoryStructurePresenter.this.view.hideBusyIndicator();
                    RepositoryStructurePresenter.this.init();
                }
            })).save(this.model.getPathToPOM(), this.model, "");
        }
    }

    @Override
    public void onConvertToMultiModule() {
        YesNoCancelPopup yesNoCancelPopup = YesNoCancelPopup.newYesNoCancelPopup((String)CommonConstants.INSTANCE.Information(), (String)Constants.INSTANCE.ConfirmConvertToMultiModuleStructure(), (Command)new Command(){

            public void execute() {
                RepositoryStructurePresenter.this.convertToMultiModule();
            }
        }, (String)CommonConstants.INSTANCE.YES(), (ButtonType)ButtonType.PRIMARY, (IconType)IconType.SAVE, (Command)new Command(){

            public void execute() {
            }
        }, null, (ButtonType)ButtonType.DEFAULT, null, (Command)new Command(){

            public void execute() {
            }
        }, null, (ButtonType)ButtonType.DEFAULT, null);
        yesNoCancelPopup.setClosable(false);
        yesNoCancelPopup.show();
    }

    private void convertToMultiModule() {
        Project project = (Project)this.model.getOrphanProjects().get(0);
        POM pom = (POM)this.model.getOrphanProjectsPOM().get(project.getSignatureId());
        GAV gav = new GAV(this.view.getDataView().getGroupId(), this.view.getDataView().getArtifactId(), this.view.getDataView().getVersionId());
        this.view.showBusyIndicator(Constants.INSTANCE.ConvertingToMultiModuleProject());
        ((RepositoryStructureService)this.repositoryStructureService.call((RemoteCallback)new RemoteCallback<Path>(){

            public void callback(Path response) {
                RepositoryStructurePresenter.this.view.hideBusyIndicator();
                RepositoryStructurePresenter.this.init();
            }
        })).convertToMultiProjectStructure(this.model.getOrphanProjects(), gav, this.repository, true, null);
    }

    @Override
    public void onOpenSingleProject() {
        if (this.model != null && this.model.isSingleProject()) {
            this.placeManager.goTo("projectScreen");
        }
    }

    private Project getSelectedModule(String name) {
        Project project = null;
        if (this.model != null && name != null) {
            if (this.model.isMultiModule()) {
                project = this.model.getModulesProject() != null ? (Project)this.model.getModulesProject().get(name) : null;
            } else if (this.model.getOrphanProjects() != null) {
                for (Project _project : this.model.getOrphanProjects()) {
                    if (!name.equals(_project.getProjectName())) continue;
                    project = _project;
                    break;
                }
            }
        }
        return project;
    }

    private void removeFromModulesList(String module) {
        if (module != null) {
            int index = -1;
            for (ProjectModuleRow row : this.dataProvider.getList()) {
                ++index;
                if (!module.equals(row.getName())) continue;
                break;
            }
            if (index >= 0 && (index == 0 || index < this.dataProvider.getList().size())) {
                this.dataProvider.getList().remove(index);
            }
        }
    }

    private void addToModulesList(Project project) {
        ProjectModuleRow row = new ProjectModuleRow(project.getProjectName());
        if (!this.dataProvider.getList().contains(row)) {
            this.dataProvider.getList().add(row);
        }
    }

    private boolean repositoryOrBranchChanged(Repository selectedRepository) {
        return selectedRepository != null && (!selectedRepository.equals(this.repository) || !selectedRepository.getCurrentBranch().equals(this.branch));
    }

    private void makeMenuBar() {
        final ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        this.configure = (MenuItem)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)Constants.INSTANCE.Configure()).withRoles((Collection)this.kieACL.getGrantedRoles("wb_configure_repository"))).respondsWith(this.getConfigureCommand())).endMenu()).build().getItems().get(0);
        this.promote = (MenuItem)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)Constants.INSTANCE.Promote()).withRoles((Collection)this.kieACL.getGrantedRoles("wb_promote_assets"))).respondsWith(this.getPromoteCommand())).endMenu()).build().getItems().get(0);
        this.release = (MenuItem)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)Constants.INSTANCE.Release()).withRoles((Collection)this.kieACL.getGrantedRoles("wb_release_project"))).respondsWith(this.getReleaseCommand())).endMenu()).build().getItems().get(0);
        items.add(this.configure);
        items.add(this.promote);
        items.add(this.release);
        this.menus = new Menus(){

            public List<MenuItem> getItems() {
                return items;
            }

            public Map<Object, MenuItem> getItemsMap() {
                return new HashMap<Object, MenuItem>(){
                    {
                        this.put(MenuItems.CONFIGURE_MENU_ITEM, RepositoryStructurePresenter.this.configure);
                        this.put(MenuItems.PROMOTE_MENU_ITEM, RepositoryStructurePresenter.this.promote);
                        this.put(MenuItems.RELEASE_MENU_ITEM, RepositoryStructurePresenter.this.release);
                    }
                };
            }

            public void accept(MenuVisitor visitor) {
                if (visitor.visitEnter((Menus)this)) {
                    for (MenuItem item : items) {
                        item.accept(visitor);
                    }
                    visitor.visitLeave((Menus)this);
                }
            }
        };
        MenuItem item = this.getItem(MenuItems.CONFIGURE_MENU_ITEM);
        this.configureIsGranted = item != null && item.isEnabled();
        item = this.getItem(MenuItems.PROMOTE_MENU_ITEM);
        this.promoteIsGranted = item != null && item.isEnabled();
        item = this.getItem(MenuItems.RELEASE_MENU_ITEM);
        this.releaseIsGranted = item != null && item.isEnabled();
    }

    private void enableAssetsManagementMenu(boolean enable) {
        this.enableConfigure(this.configureIsGranted && enable);
        this.enablePromote(this.promoteIsGranted && enable);
        this.enableRelease(this.releaseIsGranted && enable);
    }

    private void enableConfigure(boolean enable) {
        this.configure.setEnabled(enable);
    }

    private void enablePromote(boolean enable) {
        this.promote.setEnabled(enable);
    }

    private void enableRelease(boolean enable) {
        this.release.setEnabled(enable);
    }

    private MenuItem getItem(MenuItems itemKey) {
        return this.menus != null ? (MenuItem)this.menus.getItemsMap().get((Object)itemKey) : null;
    }

    private Command getConfigureCommand() {
        return new Command(){

            public void execute() {
                POM pom = null;
                if (RepositoryStructurePresenter.this.model != null && (RepositoryStructurePresenter.this.model.isSingleProject() || RepositoryStructurePresenter.this.model.isMultiModule())) {
                    pom = RepositoryStructurePresenter.this.model.isMultiModule() ? RepositoryStructurePresenter.this.model.getPOM() : RepositoryStructurePresenter.this.model.getSingleProjectPOM();
                    RepositoryStructurePresenter.this.view.getConfigureScreenPopupView().configure(RepositoryStructurePresenter.this.repository.getAlias(), RepositoryStructurePresenter.this.branch, pom.getGav().getVersion(), new com.google.gwt.user.client.Command(){

                        public void execute() {
                            String devBranch = RepositoryStructurePresenter.this.view.getConfigureScreenPopupView().getDevBranch();
                            String releaseBranch = RepositoryStructurePresenter.this.view.getConfigureScreenPopupView().getReleaseBranch();
                            String version = RepositoryStructurePresenter.this.view.getConfigureScreenPopupView().getVersion();
                            RepositoryStructurePresenter.this.configureRepository(RepositoryStructurePresenter.this.repository.getAlias(), RepositoryStructurePresenter.this.branch, devBranch, releaseBranch, version);
                            RepositoryStructurePresenter.this.view.getConfigureScreenPopupView().hide();
                        }
                    });
                    RepositoryStructurePresenter.this.view.getConfigureScreenPopupView().show();
                }
            }
        };
    }

    private Command getPromoteCommand() {
        return new Command(){

            public void execute() {
                RepositoryStructurePresenter.this.view.getPromoteScreenPopupView().configure(RepositoryStructurePresenter.this.repository.getAlias(), RepositoryStructurePresenter.this.branch, RepositoryStructurePresenter.this.repository.getBranches(), new com.google.gwt.user.client.Command(){

                    public void execute() {
                        String targetBranch = RepositoryStructurePresenter.this.view.getPromoteScreenPopupView().getTargetBranch();
                        RepositoryStructurePresenter.this.promoteChanges(RepositoryStructurePresenter.this.repository.getAlias(), RepositoryStructurePresenter.this.branch, targetBranch);
                        RepositoryStructurePresenter.this.view.getPromoteScreenPopupView().hide();
                    }
                });
                RepositoryStructurePresenter.this.view.getPromoteScreenPopupView().show();
            }
        };
    }

    private Command getReleaseCommand() {
        return new Command(){

            public void execute() {
                POM pom = null;
                if (RepositoryStructurePresenter.this.model != null && (RepositoryStructurePresenter.this.model.isSingleProject() || RepositoryStructurePresenter.this.model.isMultiModule())) {
                    pom = RepositoryStructurePresenter.this.model.isMultiModule() ? RepositoryStructurePresenter.this.model.getPOM() : RepositoryStructurePresenter.this.model.getSingleProjectPOM();
                    RepositoryStructurePresenter.this.view.getReleaseScreenPopupView().configure(RepositoryStructurePresenter.this.repository.getAlias(), RepositoryStructurePresenter.this.branch, RepositoryStructurePresenter.this.trimSnapshotFromVersion(pom.getGav().getVersion()), pom.getGav().getVersion(), new com.google.gwt.user.client.Command(){

                        public void execute() {
                            String username = RepositoryStructurePresenter.this.view.getReleaseScreenPopupView().getUsername();
                            String password = RepositoryStructurePresenter.this.view.getReleaseScreenPopupView().getPassword();
                            String serverURL = RepositoryStructurePresenter.this.view.getReleaseScreenPopupView().getServerURL();
                            String version = RepositoryStructurePresenter.this.view.getReleaseScreenPopupView().getVersion();
                            Boolean deployToRuntime = RepositoryStructurePresenter.this.view.getReleaseScreenPopupView().getDeployToRuntime();
                            RepositoryStructurePresenter.this.releaseProject(RepositoryStructurePresenter.this.repository.getAlias(), RepositoryStructurePresenter.this.branch, username, password, serverURL, deployToRuntime, version);
                            RepositoryStructurePresenter.this.view.getReleaseScreenPopupView().hide();
                        }
                    });
                    RepositoryStructurePresenter.this.view.getReleaseScreenPopupView().show();
                }
            }
        };
    }

    private String trimSnapshotFromVersion(String version) {
        if (version != null && version.endsWith("-SNAPSHOT")) {
            return version.replace("-SNAPSHOT", "");
        }
        return version;
    }

    public void configureRepository(String repository, String sourceBranch, String devBranch, String releaseBranch, String version) {
        ((AssetManagementService)this.assetManagementServices.call((RemoteCallback)new RemoteCallback<Long>(){

            public void callback(Long taskId) {
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                RepositoryStructurePresenter.this.errorPopup.showMessage("Unexpected error encountered : " + throwable.getMessage());
                return true;
            }
        })).configureRepository(repository, sourceBranch, devBranch, releaseBranch, version);
    }

    public void promoteChanges(String repository, String sourceBranch, String destinationBranch) {
        ((AssetManagementService)this.assetManagementServices.call((RemoteCallback)new RemoteCallback<Long>(){

            public void callback(Long taskId) {
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                RepositoryStructurePresenter.this.errorPopup.showMessage("Unexpected error encountered : " + throwable.getMessage());
                return true;
            }
        })).promoteChanges(repository, sourceBranch, destinationBranch);
    }

    public void releaseProject(String repository, String branch, String userName, String password, String serverURL, Boolean deployToRuntime, String version) {
        if (serverURL != null && !serverURL.isEmpty() && serverURL.endsWith("/")) {
            serverURL = serverURL.substring(0, serverURL.length() - 1);
        }
        ((AssetManagementService)this.assetManagementServices.call((RemoteCallback)new RemoteCallback<Long>(){

            public void callback(Long taskId) {
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ErrorPopup.showMessage((String)("Unexpected error encountered : " + throwable.getMessage()));
                return true;
            }
        })).releaseProject(repository, branch, userName, password, serverURL, deployToRuntime, version);
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return this.menus;
    }

    public static enum MenuItems {
        CONFIGURE_MENU_ITEM,
        PROMOTE_MENU_ITEM,
        RELEASE_MENU_ITEM;

    }
}

