/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.client.editors.repository.wizard.pages;

import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.guvnor.asset.management.client.editors.repository.wizard.CreateRepositoryWizardModel;
import org.guvnor.asset.management.client.editors.repository.wizard.WizardTestUtils;
import org.guvnor.asset.management.client.editors.repository.wizard.pages.RepositoryInfoPage;
import org.guvnor.asset.management.client.editors.repository.wizard.pages.RepositoryInfoPageView;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.organizationalunit.OrganizationalUnitServiceCallerMock;
import org.guvnor.structure.organizationalunit.impl.OrganizationalUnitImpl;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.repositories.RepositoryServiceCallerMock;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;

@RunWith(value=GwtMockitoTestRunner.class)
public class RepositoryInfoPageTest {
    @GwtMock
    RepositoryInfoPageView view;
    OrganizationalUnitService organizationalUnitService = (OrganizationalUnitService)Mockito.mock(OrganizationalUnitService.class);
    RepositoryService repositoryService = (RepositoryService)Mockito.mock(RepositoryService.class);
    List<OrganizationalUnit> organizationalUnits = RepositoryInfoPageTest.buildOrganiztionalUnits();
    List<Pair<String, String>> organizationalUnitsInfo = RepositoryInfoPageTest.buildOrganiztionalUnitsInfo(this.organizationalUnits);

    @Test
    public void testPageLoad() {
        RepositoryInfoPageExtended infoPage = new RepositoryInfoPageExtended(this.view, (Caller<OrganizationalUnitService>)new OrganizationalUnitServiceCallerMock(this.organizationalUnitService), (Caller<RepositoryService>)new RepositoryServiceCallerMock(this.repositoryService), true, new WizardTestUtils.WizardPageStatusChangeEventMock());
        CreateRepositoryWizardModel model = new CreateRepositoryWizardModel();
        infoPage.setModel(model);
        Mockito.when((Object)this.organizationalUnitService.getOrganizationalUnits()).thenReturn(this.organizationalUnits);
        infoPage.prepareView();
        ((RepositoryInfoPageView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)infoPage);
        ((RepositoryInfoPageView)Mockito.verify((Object)this.view)).initOrganizationalUnits((List)Mockito.eq(this.organizationalUnitsInfo));
        WizardTestUtils.assertPageComplete(false, (WizardPage)infoPage);
    }

    @Test
    public void testOrganizationalUnitChange() {
        RepositoryInfoPageExtended infoPage = new RepositoryInfoPageExtended(this.view, (Caller<OrganizationalUnitService>)new OrganizationalUnitServiceCallerMock(this.organizationalUnitService), (Caller<RepositoryService>)new RepositoryServiceCallerMock(this.repositoryService), true, new WizardTestUtils.WizardPageStatusChangeEventMock());
        CreateRepositoryWizardModel model = new CreateRepositoryWizardModel();
        infoPage.setModel(model);
        Mockito.when((Object)this.organizationalUnitService.getOrganizationalUnits()).thenReturn(this.organizationalUnits);
        Mockito.when((Object)this.view.getOrganizationalUnitName()).thenReturn((Object)"OrganizationalUnit1");
        infoPage.prepareView();
        infoPage.onOUChange();
        ((RepositoryInfoPageView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).getOrganizationalUnitName();
        Assert.assertEquals((Object)this.organizationalUnits.get(0), (Object)model.getOrganizationalUnit());
        WizardTestUtils.assertPageComplete(false, (WizardPage)infoPage);
    }

    @Test
    public void testValidRepositoryNameChange() {
        RepositoryInfoPageExtended infoPage = new RepositoryInfoPageExtended(this.view, (Caller<OrganizationalUnitService>)new OrganizationalUnitServiceCallerMock(this.organizationalUnitService), (Caller<RepositoryService>)new RepositoryServiceCallerMock(this.repositoryService), true, new WizardTestUtils.WizardPageStatusChangeEventMock());
        CreateRepositoryWizardModel model = new CreateRepositoryWizardModel();
        infoPage.setModel(model);
        Mockito.when((Object)this.repositoryService.validateRepositoryName("ValidRepo")).thenReturn((Object)true);
        Mockito.when((Object)this.repositoryService.validateRepositoryName("InvalidRepo")).thenReturn((Object)false);
        Mockito.when((Object)this.view.getName()).thenReturn((Object)"ValidRepo");
        infoPage.onNameChange();
        ((RepositoryInfoPageView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).getName();
        ((RepositoryInfoPageView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearNameErrorMessage();
        Assert.assertEquals((Object)"ValidRepo", (Object)model.getRepositoryName());
        WizardTestUtils.assertPageComplete(false, (WizardPage)infoPage);
    }

    @Test
    public void testInvalidRepositoryNameChange() {
        RepositoryInfoPageExtended infoPage = new RepositoryInfoPageExtended(this.view, (Caller<OrganizationalUnitService>)new OrganizationalUnitServiceCallerMock(this.organizationalUnitService), (Caller<RepositoryService>)new RepositoryServiceCallerMock(this.repositoryService), true, new WizardTestUtils.WizardPageStatusChangeEventMock());
        CreateRepositoryWizardModel model = new CreateRepositoryWizardModel();
        infoPage.setModel(model);
        Mockito.when((Object)this.repositoryService.validateRepositoryName("ValidRepo")).thenReturn((Object)true);
        Mockito.when((Object)this.repositoryService.validateRepositoryName("InvalidRepo")).thenReturn((Object)false);
        Mockito.when((Object)this.view.getName()).thenReturn((Object)"InvalidRepo");
        infoPage.onNameChange();
        ((RepositoryInfoPageView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).getName();
        ((RepositoryInfoPageView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setNameErrorMessage(Mockito.anyString());
        Assert.assertEquals((Object)"InvalidRepo", (Object)model.getRepositoryName());
        WizardTestUtils.assertPageComplete(false, (WizardPage)infoPage);
    }

    @Test
    public void testManagedRepositorySelected() {
        this.testManagedRepositoryChange(true);
    }

    @Test
    public void testUnManagedRepositorySelected() {
        this.testManagedRepositoryChange(false);
    }

    private void testManagedRepositoryChange(boolean isManaged) {
        RepositoryInfoPageExtended infoPage = new RepositoryInfoPageExtended(this.view, (Caller<OrganizationalUnitService>)new OrganizationalUnitServiceCallerMock(this.organizationalUnitService), (Caller<RepositoryService>)new RepositoryServiceCallerMock(this.repositoryService), true, new WizardTestUtils.WizardPageStatusChangeEventMock());
        CreateRepositoryWizardModel model = new CreateRepositoryWizardModel();
        infoPage.setModel(model);
        Mockito.when((Object)this.view.isManagedRepository()).thenReturn((Object)isManaged);
        infoPage.onManagedRepositoryChange();
        ((RepositoryInfoPageView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)(isManaged ? 4 : 3)))).isManagedRepository();
        Assert.assertEquals((Object)isManaged, (Object)model.isManged());
        WizardTestUtils.assertPageComplete(false, (WizardPage)infoPage);
    }

    @Test
    public void testPageCompleted() {
        RepositoryInfoPageExtended infoPage = new RepositoryInfoPageExtended(this.view, (Caller<OrganizationalUnitService>)new OrganizationalUnitServiceCallerMock(this.organizationalUnitService), (Caller<RepositoryService>)new RepositoryServiceCallerMock(this.repositoryService), true, new WizardTestUtils.WizardPageStatusChangeEventMock());
        CreateRepositoryWizardModel model = new CreateRepositoryWizardModel();
        infoPage.setModel(model);
        Mockito.when((Object)this.organizationalUnitService.getOrganizationalUnits()).thenReturn(this.organizationalUnits);
        Mockito.when((Object)this.repositoryService.validateRepositoryName("ValidRepo")).thenReturn((Object)true);
        Mockito.when((Object)this.view.getOrganizationalUnitName()).thenReturn((Object)"OrganizationalUnit1");
        Mockito.when((Object)this.view.getName()).thenReturn((Object)"ValidRepo");
        infoPage.prepareView();
        infoPage.onNameChange();
        infoPage.onOUChange();
        Assert.assertEquals((Object)this.organizationalUnits.get(0), (Object)model.getOrganizationalUnit());
        Assert.assertEquals((Object)"ValidRepo", (Object)model.getRepositoryName());
        WizardTestUtils.assertPageComplete(true, (WizardPage)infoPage);
    }

    public static List<OrganizationalUnit> buildOrganiztionalUnits() {
        ArrayList<OrganizationalUnit> organizationalUnits = new ArrayList<OrganizationalUnit>();
        OrganizationalUnitImpl organizationalUnit = new OrganizationalUnitImpl("OrganizationalUnit1", "user1", "group1");
        organizationalUnits.add((OrganizationalUnit)organizationalUnit);
        organizationalUnit = new OrganizationalUnitImpl("OrganizationalUnit2", "user2", "group2");
        organizationalUnits.add((OrganizationalUnit)organizationalUnit);
        return organizationalUnits;
    }

    public static List<Pair<String, String>> buildOrganiztionalUnitsInfo(Collection<OrganizationalUnit> organizationalUnits) {
        ArrayList<Pair<String, String>> organizationalUnitsInfo = new ArrayList<Pair<String, String>>();
        for (OrganizationalUnit organizationalUnit : organizationalUnits) {
            organizationalUnitsInfo.add((Pair<String, String>)new Pair((Object)organizationalUnit.getName(), (Object)organizationalUnit.getName()));
        }
        return organizationalUnitsInfo;
    }

    public static class RepositoryInfoPageExtended
    extends RepositoryInfoPage {
        private boolean ouMandatory = false;

        public RepositoryInfoPageExtended(RepositoryInfoPageView view, Caller<OrganizationalUnitService> organizationalUnitService, Caller<RepositoryService> repositoryService, boolean ouMandatory, WizardTestUtils.WizardPageStatusChangeEventMock event) {
            super(view, organizationalUnitService, repositoryService);
            this.ouMandatory = ouMandatory;
            this.wizardPageStatusChangeEvent = event;
            super.init();
        }

        protected boolean isOUMandatory() {
            return this.ouMandatory;
        }
    }
}

