/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.client.editors.forms.promote;

import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.guvnor.asset.management.client.editors.forms.promote.SelectAssetsToPromotePresenter;
import org.guvnor.asset.management.client.i18n.Constants;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.common.client.forms.GetFormParamsEvent;
import org.uberfire.ext.widgets.common.client.forms.RequestFormParamsEvent;
import org.uberfire.ext.widgets.common.client.forms.SetFormParamsEvent;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.PlaceRequest;

@RunWith(value=GwtMockitoTestRunner.class)
public class SelectAssetsToPromotePresenterTest
extends TestCase {
    protected List<FileCommitsLog> commitsLog;
    protected FileCommitsLog employeeLog;
    protected FileCommitsLog addressLog;
    protected FileCommitsLog departmentLog;
    protected FileCommitsLog officeLog;
    protected FileCommitsLog projectLog;
    private String branch = "master";
    private String filesInBranch;
    @GwtMock
    protected Constants constants;
    @Mock
    protected PlaceRequest placeRequest;
    @Mock
    protected SelectAssetsToPromotePresenter.SelectAssetsToPromoteView view;
    @Mock
    protected EventSourceMock<GetFormParamsEvent> eventMock;
    protected SelectAssetsToPromotePresenter presenter;

    @Before
    public void init() {
        this.presenter = new SelectAssetsToPromotePresenter(this.view, this.eventMock, new SelectAssetsToPromotePresenter.CommitsReader(){

            public Map<String, String> getCommitsPerFile(String commitsPerFileString) {
                HashMap<String, String> commitsPerFile = new HashMap<String, String>();
                for (FileCommitsLog log : SelectAssetsToPromotePresenterTest.this.commitsLog) {
                    StringBuffer commits = new StringBuffer();
                    for (String commit : log.getCommits()) {
                        if (commits.length() > 0) {
                            commits.append(",");
                        }
                        commits.append(commit);
                    }
                    commitsPerFile.put(log.getPath(), commits.toString());
                }
                return commitsPerFile;
            }
        });
        this.initLogInfo();
    }

    @Test
    public void testBasicMethods() {
        this.presenter.onStartup(this.placeRequest);
        SelectAssetsToPromotePresenterTest.assertEquals((String)"Presenter has wrong view.", (Object)this.view, (Object)this.presenter.getView());
        this.presenter.getTitle();
        ((Constants)Mockito.verify((Object)this.constants)).Promote_Assets();
        this.presenter.setRequiresReview(Boolean.TRUE);
    }

    @Test
    public void testAssetSelection() {
        this.startTest();
        int promotedFiles = 1;
        for (FileCommitsLog log : this.commitsLog) {
            this.presenter.addFileToPromotedList(log.getPath());
            ((SelectAssetsToPromotePresenter.SelectAssetsToPromoteView)Mockito.verify((Object)this.view)).addFileToPromote(log.getPath());
            this.checkPromotedFiles(promotedFiles);
            ++promotedFiles;
        }
        promotedFiles = this.commitsLog.size();
        for (FileCommitsLog log : this.commitsLog) {
            this.presenter.removeFileFromPromotedList(log.getPath());
            ((SelectAssetsToPromotePresenter.SelectAssetsToPromoteView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.atLeastOnce())).addFieldInBranch(log.getPath());
            this.checkPromotedFiles(--promotedFiles);
        }
    }

    @Test
    public void testSelectAssetsFormResult() {
        this.startTest();
        this.presenter.addFileToPromotedList(this.employeeLog.getPath());
        this.presenter.addFileToPromotedList(this.departmentLog.getPath());
        this.presenter.addFileToPromotedList(this.projectLog.getPath());
        this.presenter.getOutputMap(new RequestFormParamsEvent());
        ArgumentCaptor getFormParamsCaptor = ArgumentCaptor.forClass(GetFormParamsEvent.class);
        ((EventSourceMock)Mockito.verify(this.eventMock)).fire(getFormParamsCaptor.capture());
        SelectAssetsToPromotePresenterTest.assertNotNull((String)"No GetFormParamsEvent generated.", (Object)getFormParamsCaptor.getValue());
        Map resultParams = ((GetFormParamsEvent)getFormParamsCaptor.getValue()).getParams();
        String commits = (String)resultParams.get("out_commits");
        this.checkFileCommits(commits, this.employeeLog.getCommits());
        this.checkFileCommits(commits, this.departmentLog.getCommits());
        this.checkFileCommits(commits, this.projectLog.getCommits());
        Boolean requiresReview = (Boolean)resultParams.get("out_requires_review");
        SelectAssetsToPromotePresenterTest.assertEquals((String)"Result contains wrong value for 'out_requires_review'.", (Object)this.presenter.getRequiresReview(), (Object)requiresReview);
    }

    protected void startTest() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("in_source_branch_name", this.branch);
        params.put("in_list_of_files", this.filesInBranch);
        params.put("in_commits_per_file", "");
        SetFormParamsEvent setFormParamsEvent = new SetFormParamsEvent(params, false);
        this.presenter.setInputMap(setFormParamsEvent);
        ((SelectAssetsToPromotePresenter.SelectAssetsToPromoteView)Mockito.verify((Object)this.view)).setSourceBranch(this.branch);
        ((SelectAssetsToPromotePresenter.SelectAssetsToPromoteView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)5))).addFieldInBranch(Mockito.anyString());
        ((SelectAssetsToPromotePresenter.SelectAssetsToPromoteView)Mockito.verify((Object)this.view)).setReadOnly(Boolean.FALSE.booleanValue());
        SelectAssetsToPromotePresenterTest.assertEquals((String)("Presenter must contain " + this.commitsLog.size() + " files in branch. "), (int)this.commitsLog.size(), (int)this.presenter.getCommitsPerFile().size());
    }

    protected void checkFileCommits(String commits, String[] fileCommits) {
        for (String commit : fileCommits) {
            SelectAssetsToPromotePresenterTest.assertTrue((String)("Commits list '" + commits + "' must contain commit '" + commit + "'."), (boolean)commits.contains(commit));
        }
    }

    protected void checkPromotedFiles(int filesToPromote) {
        SelectAssetsToPromotePresenterTest.assertEquals((String)("Presenter must contain " + filesToPromote + " files to promote. "), (int)filesToPromote, (int)this.presenter.getFilesToPromote().size());
    }

    protected void initLogInfo() {
        this.employeeLog = new FileCommitsLog("src/main/java/org/guvnor/asset/management/test/Employee.java", new String[]{"d7b6f69712291cd94a16800ac6a01e12c6119e3d", "70eb7440daeff2b62506d5a45b5016807e6752a3"});
        this.addressLog = new FileCommitsLog("src/main/java/org/guvnor/asset/management/test/Address.java", new String[]{"d7b6f69712291cd94a16800ac6a01e12c6119e3d", "ec3859477dcdf86a69bd70955ebc9188cfa9dc36"});
        this.departmentLog = new FileCommitsLog("src/main/java/org/guvnor/asset/management/test/Department.java", new String[]{"d7b6f69712291cd94a16800ac6a01e12c6119e3d", "ec3859477dcdf86a69bd70955ebc9188cfa9dc36", "90a4e33d4a53cdbaa7258021cd0f22f853e6eebd"});
        this.officeLog = new FileCommitsLog("src/main/java/org/guvnor/asset/management/test/Office.java", new String[]{"d7b6f69712291cd94a16800ac6a01e12c6119e3d"});
        this.projectLog = new FileCommitsLog("src/main/java/org/guvnor/asset/management/test/Project.java", new String[]{"70eb7440daeff2b62506d5a45b5016807e6752a3"});
        this.commitsLog = new ArrayList<FileCommitsLog>();
        this.commitsLog.add(this.employeeLog);
        this.commitsLog.add(this.addressLog);
        this.commitsLog.add(this.departmentLog);
        this.commitsLog.add(this.officeLog);
        this.commitsLog.add(this.projectLog);
        StringBuffer files = new StringBuffer();
        for (FileCommitsLog log : this.commitsLog) {
            if (files.length() > 0) {
                files.append(",");
            }
            files.append(log.getPath());
        }
        this.filesInBranch = files.toString();
    }

    private class FileCommitsLog {
        private String path;
        private String[] commits;

        public FileCommitsLog(String path, String[] commits) {
            this.path = path;
            this.commits = commits;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String[] getCommits() {
            return this.commits;
        }

        public void setCommits(String[] commits) {
            this.commits = commits;
        }
    }
}

