/*
 * Decompiled with CFR 0.152.
 */
package org.grpcmock.junit5;

import io.grpc.ServerInterceptor;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.grpcmock.GrpcMock;
import org.grpcmock.GrpcMockBuilder;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcMockExtension
implements BeforeAllCallback,
AfterAllCallback,
AfterEachCallback {
    private static final Logger log = LoggerFactory.getLogger(GrpcMockExtension.class);
    protected final GrpcMock server;

    public GrpcMockExtension() {
        this(GrpcMock.grpcMock().build());
    }

    public GrpcMockExtension(@Nonnull GrpcMock server) {
        Objects.requireNonNull(server);
        this.server = server;
        this.init();
    }

    public static Builder builder() {
        return new Builder();
    }

    private void init() {
        this.server.start();
        GrpcMock.configureFor((GrpcMock)this.server);
        this.logServerStarted();
    }

    protected void logServerStarted() {
        log.debug("Started gRPC Mock server at port: {}", (Object)this.getPort());
    }

    public int getPort() {
        return this.server.getPort();
    }

    public GrpcMock getInstance() {
        return this.server;
    }

    public void beforeAll(ExtensionContext extensionContext) {
        this.server.resetAll();
        log.debug("Resetting all stub mappings before the tests");
    }

    public void afterAll(ExtensionContext extensionContext) {
        this.server.resetAll();
        this.server.stop();
        log.debug("Stopping gRPC Mock server.");
    }

    public void afterEach(ExtensionContext extensionContext) {
        this.server.resetAll();
        log.debug("Resetting all stub mappings after a test");
    }

    public static class Builder {
        private int port = 0;
        private Executor executor;
        private final List<ServerInterceptor> interceptors = new ArrayList<ServerInterceptor>();
        private File certChain;
        private File privateKey;

        Builder() {
        }

        public Builder withPort(int port) {
            this.port = port;
            return this;
        }

        public Builder withExecutor(@Nullable Executor executor) {
            this.executor = executor;
            return this;
        }

        public Builder withInterceptor(@Nonnull ServerInterceptor interceptor) {
            Objects.requireNonNull(interceptor);
            this.interceptors.add(interceptor);
            return this;
        }

        public Builder withTransportSecurity(@Nonnull File certChain, @Nonnull File privateKey) {
            Objects.requireNonNull(certChain);
            Objects.requireNonNull(privateKey);
            this.certChain = certChain;
            this.privateKey = privateKey;
            return this;
        }

        public Builder withTransportSecurity(@Nonnull String certChain, @Nonnull String privateKey) {
            Objects.requireNonNull(certChain);
            Objects.requireNonNull(privateKey);
            this.certChain = Paths.get(certChain, new String[0]).toFile();
            this.privateKey = Paths.get(privateKey, new String[0]).toFile();
            return this;
        }

        public GrpcMockExtension build() {
            GrpcMockBuilder builder = GrpcMock.grpcMock((int)this.port);
            Optional.ofNullable(this.executor).ifPresent(arg_0 -> ((GrpcMockBuilder)builder).executor(arg_0));
            this.interceptors.forEach(arg_0 -> ((GrpcMockBuilder)builder).interceptor(arg_0));
            if (Objects.nonNull(this.certChain) && Objects.nonNull(this.privateKey)) {
                builder.transportSecurity(this.certChain, this.privateKey);
            }
            return new GrpcMockExtension(builder.build());
        }
    }
}

