/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.zerormi.zlog;

import org.gridkit.zerormi.zlog.LogLevel;
import org.gridkit.zerormi.zlog.LogStream;
import org.gridkit.zerormi.zlog.PrintStreamLogStream;
import org.gridkit.zerormi.zlog.Slf4JStream;
import org.gridkit.zerormi.zlog.ZLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ZLogToSlf4J
implements ZLogger {
    private final String root;

    public ZLogToSlf4J() {
        this.root = "";
    }

    public ZLogToSlf4J(String root) {
        this.root = root;
    }

    @Override
    public ZLogger getLogger(String path) {
        String ln = this.root;
        if (path != null && path.length() > 0) {
            ln = ln + (ln.length() == 0 ? "" : ".") + path;
        }
        return new ZLogToSlf4J(ln);
    }

    @Override
    public LogStream get(String path, LogLevel level) {
        if (level == null) {
            throw new NullPointerException("log level should not be null");
        }
        String ln = this.root;
        if (path != null && path.length() > 0) {
            ln = ln + (ln.length() == 0 ? "" : ".") + path;
        }
        Logger l = LoggerFactory.getLogger((String)ln);
        switch (level) {
            case TRACE: {
                return new Slf4JStream(l, Slf4JStream.Level.TRACE);
            }
            case DEBUG: {
                return new Slf4JStream(l, Slf4JStream.Level.DEBUG);
            }
            case VERBOSE: {
                return new Slf4JStream(l, Slf4JStream.Level.DEBUG);
            }
            case INFO: {
                return new Slf4JStream(l, Slf4JStream.Level.INFO);
            }
            case WARN: {
                return new Slf4JStream(l, Slf4JStream.Level.WARN);
            }
            case CRITICAL: {
                return new Slf4JStream(l, Slf4JStream.Level.ERROR);
            }
            case FATAL: {
                return new Slf4JStream(l, Slf4JStream.Level.ERROR);
            }
        }
        return new PrintStreamLogStream("", null, false);
    }

    @Override
    public LogStream fatal() {
        return this.get("", LogLevel.FATAL);
    }

    @Override
    public LogStream critical() {
        return this.get("", LogLevel.CRITICAL);
    }

    @Override
    public LogStream warn() {
        return this.get("", LogLevel.WARN);
    }

    @Override
    public LogStream info() {
        return this.get("", LogLevel.INFO);
    }

    @Override
    public LogStream verbose() {
        return this.get("", LogLevel.VERBOSE);
    }

    @Override
    public LogStream debug() {
        return this.get("", LogLevel.DEBUG);
    }

    @Override
    public LogStream trace() {
        return this.get("", LogLevel.TRACE);
    }
}

