/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.zerormi.zlog;

import org.gridkit.zerormi.zlog.PrintStreamLogger;
import org.gridkit.zerormi.zlog.ZLogger;

public class ZLogFactory {
    public static final String PROP_ZLOG_MODE = "org.gridkit.zlog.mode";

    public static ZLogger getStdErrRootLogger() {
        return new PrintStreamLogger("", System.err);
    }

    public static ZLogger getDefaultRootLogger() {
        if ("slf4j".equals(System.getProperty(PROP_ZLOG_MODE))) {
            return ZLogFactory.getSlf4JRootLogger();
        }
        return ZLogFactory.getStdErrRootLogger();
    }

    public static ZLogger getSlf4JRootLogger() {
        try {
            return (ZLogger)Class.forName("org.gridkit.zerormi.zlog.ZLogToSlf4J").newInstance();
        }
        catch (ClassNotFoundException e) {
            return ZLogFactory.getStdErrRootLogger();
        }
        catch (NoClassDefFoundError e) {
            return ZLogFactory.getStdErrRootLogger();
        }
        catch (InstantiationException e) {
            return ZLogFactory.getStdErrRootLogger();
        }
        catch (IllegalAccessException e) {
            return ZLogFactory.getStdErrRootLogger();
        }
    }
}

