/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.zerormi.zlog;

import org.gridkit.zerormi.zlog.AbstractLogStream;
import org.slf4j.Logger;

class Slf4JStream
extends AbstractLogStream {
    private final Logger logger;
    private final Level level;

    public Slf4JStream(Logger logger, Level level) {
        this.logger = logger;
        this.level = level;
    }

    @Override
    public boolean isEnabled() {
        switch (this.level) {
            case NONE: {
                return false;
            }
            case ERROR: {
                return this.logger.isErrorEnabled();
            }
            case WARN: {
                return this.logger.isWarnEnabled();
            }
            case INFO: {
                return this.logger.isInfoEnabled();
            }
            case DEBUG: {
                return this.logger.isDebugEnabled();
            }
            case TRACE: {
                return this.logger.isTraceEnabled();
            }
        }
        throw new Error("No such enum element: " + (Object)((Object)this.level));
    }

    @Override
    protected void logInternal(String msg, Throwable e) {
        if (e == null) {
            switch (this.level) {
                case ERROR: {
                    this.logger.error(msg);
                    break;
                }
                case WARN: {
                    this.logger.warn(msg);
                    break;
                }
                case INFO: {
                    this.logger.info(msg);
                    break;
                }
                case DEBUG: {
                    this.logger.debug(msg);
                    break;
                }
                case TRACE: {
                    this.logger.trace(msg);
                }
            }
        } else {
            switch (this.level) {
                case ERROR: {
                    this.logger.error(msg, e);
                    break;
                }
                case WARN: {
                    this.logger.warn(msg, e);
                    break;
                }
                case INFO: {
                    this.logger.info(msg, e);
                    break;
                }
                case DEBUG: {
                    this.logger.debug(msg, e);
                    break;
                }
                case TRACE: {
                    this.logger.trace(msg, e);
                }
            }
        }
    }

    public static enum Level {
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE,
        NONE;

    }
}

