/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.zerormi.zlog;

import java.io.PrintStream;
import org.gridkit.zerormi.zlog.LogLevel;
import org.gridkit.zerormi.zlog.LogStream;
import org.gridkit.zerormi.zlog.PrintStreamLogStream;
import org.gridkit.zerormi.zlog.ZLogger;

class PrintStreamLogger
implements ZLogger {
    private final String root;
    private final PrintStream out;

    public PrintStreamLogger(String root, PrintStream out) {
        this.root = root;
        this.out = out;
    }

    @Override
    public ZLogger getLogger(String path) {
        String ln = this.root;
        if (path != null && path.length() > 0) {
            ln = ln + (ln.length() == 0 ? "" : ".") + path;
        }
        return new PrintStreamLogger(ln, this.out);
    }

    @Override
    public LogStream get(String path, LogLevel level) {
        String ln = this.root;
        if (path != null && path.length() > 0) {
            ln = ln + (ln.length() == 0 ? "" : ".") + path;
        }
        return this.createStream(ln, level);
    }

    @Override
    public LogStream fatal() {
        return this.get("", LogLevel.FATAL);
    }

    @Override
    public LogStream critical() {
        return this.get("", LogLevel.CRITICAL);
    }

    @Override
    public LogStream warn() {
        return this.get("", LogLevel.WARN);
    }

    @Override
    public LogStream info() {
        return this.get("", LogLevel.INFO);
    }

    @Override
    public LogStream verbose() {
        return this.get("", LogLevel.VERBOSE);
    }

    @Override
    public LogStream debug() {
        return this.get("", LogLevel.DEBUG);
    }

    @Override
    public LogStream trace() {
        return this.get("", LogLevel.TRACE);
    }

    private LogStream createStream(String name, LogLevel level) {
        String pattern = "%1$tF %1$tT.%1$tL%1$tz " + name + " - [" + level.toString() + "] %2$s";
        String propname = "zlog." + name + "." + level.toString().toLowerCase();
        boolean enabled = level == LogLevel.CRITICAL || level == LogLevel.FATAL || level == LogLevel.WARN;
        PropConfiguredLogStream sl = new PropConfiguredLogStream(pattern, this.out, propname, enabled);
        return sl;
    }

    private static class PropConfiguredLogStream
    extends PrintStreamLogStream {
        private final String propName;
        private final boolean defaultEnabled;

        public PropConfiguredLogStream(String pattern, PrintStream ps, String propName, boolean defaultEnabled) {
            super(pattern, ps, false);
            this.propName = propName;
            this.defaultEnabled = defaultEnabled;
        }

        @Override
        public void setEnabled(boolean enabled) {
            System.setProperty(this.propName, String.valueOf(enabled));
        }

        @Override
        public boolean isEnabled() {
            String val = System.getProperty(this.propName);
            return val == null ? this.defaultEnabled : "true".equalsIgnoreCase(System.getProperty(this.propName));
        }
    }
}

