/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.zerormi.util;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RemoteExporter {
    public static <T> T export(T instance, Class<T> facade, Class<?> ... otherFacades) {
        Class[] ifs = new Class[otherFacades.length + 1];
        ifs[0] = facade;
        System.arraycopy(otherFacades, 0, ifs, 1, otherFacades.length);
        return facade.cast(RemoteExporter.export(instance, Arrays.asList(ifs)));
    }

    public static Object export(Object instance, List<Class<?>> facades) {
        Handler h = new Handler(instance);
        Redirector r = new Redirector(h);
        return Proxy.newProxyInstance(facades.get(0).getClassLoader(), facades.toArray(new Class[0]), (InvocationHandler)r);
    }

    private static class MethodInfo
    implements Serializable {
        private Class<?> type;
        private String name;
        private List<Class<?>> args;

        public MethodInfo(Method m) {
            this.type = m.getDeclaringClass();
            this.name = m.getName();
            this.args = Arrays.asList(m.getParameterTypes());
        }

        public Method getMethod() {
            try {
                Method m = this.type.getMethod(this.name, this.args.toArray(new Class[0]));
                m.setAccessible(true);
                return m;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.args == null ? 0 : ((Object)this.args).hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MethodInfo other = (MethodInfo)obj;
            if (this.args == null ? other.args != null : !((Object)this.args).equals(other.args)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }
    }

    private static class Redirector
    implements InvocationHandler,
    Serializable {
        private final RemoteInvocationHandler handler;

        public Redirector(RemoteInvocationHandler handler) {
            this.handler = handler;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass() == Object.class) {
                try {
                    Object result = method.invoke((Object)this, args);
                    return result;
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
            try {
                MethodInfo mi = new MethodInfo(method);
                Object result = this.handler.invoke(mi, args);
                return result;
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
    }

    private static class Handler
    implements RemoteInvocationHandler {
        private final Object target;
        private final Map<MethodInfo, Method> methodCache = new ConcurrentHashMap<MethodInfo, Method>(16, 0.75f, 1);

        public Handler(Object target) {
            this.target = target;
        }

        @Override
        public Object invoke(MethodInfo method, Object[] args) throws Throwable {
            Method m;
            if (!this.methodCache.containsKey(method)) {
                m = method.getMethod();
                this.methodCache.put(method, m);
            }
            m = this.methodCache.get(method);
            return m.invoke(this.target, args);
        }
    }

    public static interface RemoteInvocationHandler
    extends Remote {
        public Object invoke(MethodInfo var1, Object[] var2) throws Throwable;
    }
}

