/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.zerormi.hub;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.gridkit.zerormi.SocketStream;
import org.gridkit.zerormi.hub.RemotingHub;

public class SimpleSocketAcceptor
implements Runnable {
    private RemotingHub hub;
    private ServerSocket socket;
    private Thread acceptor;

    public void bind(ServerSocket socket, RemotingHub hub) {
        this.socket = socket;
        this.hub = hub;
    }

    public void start() {
        this.acceptor = new Thread(this);
        this.acceptor.start();
    }

    @Override
    public void run() {
        try {
            while (true) {
                Socket con = this.socket.accept();
                System.out.println("Connection accepted: " + con.getRemoteSocketAddress());
                SocketStream ds = new SocketStream(con);
                this.hub.dispatch(ds);
            }
        }
        catch (IOException e) {
            if (!this.socket.isClosed()) {
                e.printStackTrace();
            }
            return;
        }
    }

    public void close() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

