/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.zerormi.hub;

import java.io.Closeable;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.gridkit.util.concurrent.AdvancedExecutor;
import org.gridkit.zerormi.DuplexStream;
import org.gridkit.zerormi.RmiGateway;
import org.gridkit.zerormi.hub.LegacySpore;
import org.gridkit.zerormi.hub.MasterHub;
import org.gridkit.zerormi.hub.SlaveSpore;
import org.gridkit.zerormi.zlog.LogLevel;
import org.gridkit.zerormi.zlog.LogStream;
import org.gridkit.zerormi.zlog.ZLogFactory;
import org.gridkit.zerormi.zlog.ZLogger;

public class RemotingHub
implements MasterHub {
    private static final int UID_LENGTH = 32;
    private LogStream logInfo;
    private LogStream logWarn;
    private LogStream logError;
    private SecureRandom srnd;
    private ConcurrentMap<String, SessionContext> connections = new ConcurrentHashMap<String, SessionContext>();

    public RemotingHub() {
        this(ZLogFactory.getDefaultRootLogger());
    }

    public RemotingHub(ZLogger logger) {
        try {
            this.logInfo = logger.get(this.getClass().getSimpleName(), LogLevel.INFO);
            this.logWarn = logger.get(this.getClass().getSimpleName(), LogLevel.WARN);
            this.logError = logger.get(this.getClass().getSimpleName(), LogLevel.CRITICAL);
            this.srnd = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SlaveSpore allocateSession(String name, SessionEventListener listener) {
        while (true) {
            String uid = this.generateUID();
            SessionContext ctx = new SessionContext();
            ctx.listener = listener;
            SessionContext sessionContext = ctx;
            synchronized (sessionContext) {
                if (this.connections.putIfAbsent(uid, ctx) == null) {
                    ctx.gateway = new RmiGateway(name);
                    ctx.gateway.setStreamErrorHandler(ctx);
                    return new LegacySpore(uid);
                }
            }
        }
    }

    @Override
    public AdvancedExecutor getSlaveExecutor(SlaveSpore spore) {
        return this.getExecutionService(LegacySpore.uidOf(spore));
    }

    @Override
    public AdvancedExecutor getExecutionService(String sessionId) {
        SessionContext ctx = (SessionContext)this.connections.get(sessionId);
        if (ctx != null) {
            return ctx.gateway.getRemoteExecutorService();
        }
        return null;
    }

    private String generateUID() {
        byte[] magic = new byte[16];
        this.srnd.nextBytes(magic);
        StringBuilder sb = new StringBuilder();
        for (byte b : magic) {
            sb.append(Integer.toHexString(0xF & b >> 4));
            sb.append(Integer.toHexString(0xF & b));
        }
        return sb.toString();
    }

    @Override
    public void dropAllSessions() {
        for (String id : this.connections.keySet()) {
            this.dropSession(id);
        }
    }

    @Override
    public void terminateSpore(SlaveSpore spore) {
        this.dropSession(LegacySpore.uidOf(spore));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropSession(String id) {
        SessionContext ctx = (SessionContext)this.connections.get(id);
        if (ctx != null) {
            SessionContext sessionContext = ctx;
            synchronized (sessionContext) {
                ctx = (SessionContext)this.connections.get(id);
                if (ctx != null) {
                    ctx.listener.closed();
                    RemotingHub.silentClose(ctx.stream);
                    ctx.gateway.shutdown();
                    this.connections.remove(id);
                    return;
                }
            }
        }
        throw new IllegalArgumentException("Connection not found " + id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatch(DuplexStream stream) {
        SessionContext ctx;
        String id = this.readId(stream);
        if (id != null && (ctx = (SessionContext)this.connections.get(id)) != null) {
            SessionContext sessionContext = ctx;
            synchronized (sessionContext) {
                ctx = (SessionContext)this.connections.get(id);
                if (ctx != null) {
                    if (ctx.stream != null) {
                        this.logWarn.log("New stream for " + id + " " + stream);
                        this.logWarn.log("Old stream for " + id + " would be disposed " + ctx.stream);
                        RemotingHub.silentClose(ctx.stream);
                        ctx.gateway.disconnect();
                        if (ctx.stream != null) {
                            ctx.listener.interrupted(ctx.stream);
                            ctx.stream = null;
                        }
                    }
                    try {
                        ctx.gateway.connect(stream);
                        ctx.stream = stream;
                        ctx.listener.connected(stream);
                    }
                    catch (IOException e) {
                        this.logError.log("Stream connection failed " + stream);
                    }
                    this.logInfo.log("Stream connected at end point " + id + " - " + stream);
                    return;
                }
            }
        }
        this.logWarn.log("Stream were not connected " + stream);
        RemotingHub.silentClose(stream);
    }

    private String readId(DuplexStream stream) {
        try {
            byte[] magic = new byte[32];
            for (int i = 0; i != magic.length; ++i) {
                magic[i] = (byte)stream.getInput().read();
            }
            return new String(magic);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static final void silentClose(Closeable ch) {
        try {
            if (ch != null) {
                ch.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class SessionContext
    implements RmiGateway.StreamErrorHandler {
        private SessionEventListener listener;
        private RmiGateway gateway;
        private DuplexStream stream;

        private SessionContext() {
        }

        @Override
        public synchronized void streamError(DuplexStream socket, Object stream, Exception error) {
            this.gateway.disconnect();
            this.stream = null;
            this.listener.interrupted(socket);
        }

        @Override
        public void streamClosed(DuplexStream socket, Object stream) {
            this.gateway.disconnect();
            this.stream = null;
            RemotingHub.this.logInfo.log("Closed: " + stream);
        }
    }

    public static interface SessionEventListener {
        public void connected(DuplexStream var1);

        public void interrupted(DuplexStream var1);

        public void reconnected(DuplexStream var1);

        public void closed();
    }
}

